/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceType;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;

public class DiseaseReferenceImpl
implements DiseaseReference {
    private DiseaseReferenceId referenceId;
    private DiseaseReferenceType referenceType = DiseaseReferenceType.NONE;

    public DiseaseReferenceImpl() {
        this.referenceId = DefaultCommentFactory.getInstance().buildDiseaseReferenceId();
    }

    public DiseaseReferenceImpl(DiseaseReference copy) {
        this();
        if (copy == null) {
            throw new IllegalArgumentException("Null value provided in the constructor");
        }
        if (copy.getDiseaseReferenceType() != null) {
            this.referenceType = copy.getDiseaseReferenceType();
        }
        if (copy.getDiseaseReferenceId() != null) {
            this.referenceId = DefaultCommentFactory.getInstance().buildDiseaseReferenceId(copy.getDiseaseReferenceId());
        }
    }

    @Override
    public DiseaseReferenceId getDiseaseReferenceId() {
        return this.referenceId;
    }

    @Override
    public void setDiseaseReferenceId(DiseaseReferenceId referenceId) {
        this.referenceId = referenceId;
    }

    @Override
    public DiseaseReferenceType getDiseaseReferenceType() {
        return this.referenceType;
    }

    @Override
    public void setDiseaseReferenceType(DiseaseReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiseaseReferenceImpl that = (DiseaseReferenceImpl)o;
        if (!this.referenceId.equals(that.referenceId)) {
            return false;
        }
        return this.referenceType.equals((Object)that.referenceType);
    }

    public int hashCode() {
        int result = this.referenceId.hashCode();
        result = 31 * result + this.referenceType.hashCode();
        return result;
    }

    public String toString() {
        return "DiseaseReferenceImpl{referenceId=" + this.referenceId + ", referenceType=" + (Object)((Object)this.referenceType) + '}';
    }
}

