/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.util.container.MapValueCollection;

public class Comments
implements Serializable {
    private EnumMap<CommentType, List<? extends Comment>> commentMap = new EnumMap(CommentType.class);

    public Collection<Comment> getComments() {
        return new MapValueCollection(comment -> this.addComment(comment), this.commentMap.values());
    }

    public <T extends Comment> void setComments(CommentType type, List<T> comments) {
        this.commentMap.remove((Object)type);
        this.commentMap.put(type, comments);
    }

    public <T extends Comment> List<T> getComments(CommentType type) {
        List<? extends Comment> retVal = this.commentMap.get((Object)type);
        if (retVal == null) {
            retVal = new ArrayList<Comment>();
            this.commentMap.put(type, retVal);
        }
        return retVal;
    }

    public void setComments(List<Comment> comments) {
        this.commentMap = new EnumMap(CommentType.class);
        for (Comment comment : comments) {
            this.addComment(comment);
        }
    }

    public void setComments(Collection<Comment> comments) {
        this.commentMap = new EnumMap(CommentType.class);
        for (Comment comment : comments) {
            this.addComment(comment);
        }
    }

    private <T extends Comment> void addComment(T o) {
        if (o == null) {
            throw new IllegalArgumentException("comment is null");
        }
        List<T> list = this.getComments(o.getCommentType());
        if (list == null) {
            ArrayList<T> newList = new ArrayList<T>();
            newList.add(o);
            this.setComments(o.getCommentType(), newList);
        } else {
            list.add(o);
        }
    }
}

