/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.uniprot.citationsNew.CitationImpl;

public class SubmissionImpl
extends CitationImpl
implements Submission,
PersistentObject {
    private SubmissionDatabase submissionDatabase;
    private long id;

    public SubmissionImpl() {
        super(CitationTypeEnum.SUBMISSION);
        this.submissionDatabase = SubmissionDatabase.UNKNOWN;
    }

    public SubmissionImpl(Submission copy) {
        super(copy);
        this.submissionDatabase = copy.getSubmittedToDatabase();
    }

    @Override
    public CitationTypeEnum getCitationType() {
        return CitationTypeEnum.SUBMISSION;
    }

    @Override
    public SubmissionDatabase getSubmittedToDatabase() {
        return this.submissionDatabase;
    }

    @Override
    public void setSubmittedToDatabase(SubmissionDatabase name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.submissionDatabase = name;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SubmissionImpl that = (SubmissionImpl)o;
        return this.submissionDatabase == that.submissionDatabase;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.submissionDatabase.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SubmissionImpl{submissionDatabase=" + (Object)((Object)this.submissionDatabase) + '}';
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

