/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.factories.XRefFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.DatabaseAttribute;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.Go;
import uk.ac.ebi.kraken.model.uniprot.dbx.DatabaseCrossReferenceImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.XDBAttributeImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.go.GoImpl;

public class DefaultXRefFactory
implements XRefFactory {
    private static DefaultXRefFactory singletonInstance;

    protected DefaultXRefFactory() {
    }

    public static DefaultXRefFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultXRefFactory();
        }
        return singletonInstance;
    }

    @Override
    public DatabaseAttribute buildXDBAttribute(String val) {
        XDBAttributeImpl attr = new XDBAttributeImpl();
        attr.setValue(val);
        return attr;
    }

    @Override
    public DatabaseCrossReference buildDatabaseCrossReference(String type) {
        return this.buildDatabaseCrossReference(DatabaseType.getDatabaseType(type));
    }

    @Override
    public DatabaseCrossReference buildDatabaseCrossReference(DatabaseType type) {
        return new DatabaseCrossReferenceImpl(type);
    }

    @Override
    public DatabaseCrossReference buildDatabaseCrossReference(DatabaseCrossReference toCopy) {
        return new DatabaseCrossReferenceImpl(toCopy);
    }

    @Override
    public Go buildGo(DatabaseCrossReference xref) {
        if (xref.getDatabase() == DatabaseType.GO) {
            return new GoImpl(xref);
        }
        return null;
    }
}

