/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.common;

import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.util.IndexField;

public class SequenceImpl
implements PersistentObject,
Sequence {
    private String value;
    private int molWeight;
    private String crc64;
    public long id;

    public SequenceImpl() {
        this.value = "";
        this.molWeight = 0;
        this.crc64 = "";
    }

    public SequenceImpl(Sequence copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.value = copy.getValue();
        this.molWeight = copy.getMolecularWeight();
        this.crc64 = copy.getCRC64();
    }

    @Override
    public Sequence subSequence(int start, int end) {
        String subsequence = this.value.substring(start, end);
        SequenceImpl result = new SequenceImpl();
        result.setValue(subsequence);
        return result;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    @IndexThisField(fieldName={IndexField.SEQUENCE_LENGTH})
    public int getLength() {
        if (this.value != null) {
            return this.value.length();
        }
        return 0;
    }

    @Override
    public int getMolecularWeight() {
        return this.molWeight;
    }

    @Override
    public void setMolecularWeight(int weight) {
        this.molWeight = weight;
    }

    @Override
    @IndexThisField(fieldName={IndexField.SEQUENCE_CRC64})
    public String getCRC64() {
        return this.crc64;
    }

    @Override
    public void setCRC64(String crc) {
        if (crc == null) {
            throw new IllegalArgumentException();
        }
        this.crc64 = crc;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newSq) {
        if (newSq == null) {
            throw new IllegalArgumentException();
        }
        this.value = newSq;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SequenceImpl)) {
            return false;
        }
        SequenceImpl sequence1 = (SequenceImpl)o;
        if (this.id != sequence1.id) {
            return false;
        }
        if (this.molWeight != sequence1.molWeight) {
            return false;
        }
        if (!this.crc64.equals(sequence1.crc64)) {
            return false;
        }
        return this.value.equals(sequence1.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 29 * result + this.molWeight;
        result = 29 * result + this.crc64.hashCode();
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return "Sequence: {\n  value  :" + this.value + "\n  length    :" + this.getLength() + "\n  mol weight:" + this.molWeight + "\n  crc64     :" + this.crc64 + "\n}";
    }
}

