/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.description;

public enum FieldType {
    FULL("Full"),
    SHORT("Short"),
    EC("EC"),
    ALLERGEN("Allergen"),
    BIOTECH("Biotech"),
    CD_ANTIGEN("CD_antigen"),
    INN("INN"),
    UNKNOWN("Unknown");

    private String value;

    private FieldType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static FieldType typeOf(String value) {
        for (FieldType fieldType : FieldType.values()) {
            if (!fieldType.getValue().equalsIgnoreCase(value)) continue;
            return fieldType;
        }
        throw new IllegalArgumentException(String.format("The FieldType with value %s does not exist", value));
    }

    public String toString() {
        return "FieldType{value='" + this.value + '\'' + '}';
    }
}

