/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniparc;

public enum SignatureDBType {
    CDD("CDD"),
    GENE3D("Gene3D"),
    HAMAP("HAMAP"),
    PANTHER("PANTHER"),
    PFAM("Pfam"),
    PIRSF("PIRSF"),
    PRINTS("PRINTS"),
    PRODOM("ProDom"),
    PROSITE("PROSITE"),
    SFLD("SFLD"),
    SMART("SMART"),
    SUPERFAMILY("SUPFAM"),
    TIGRFAM("TIGRFAMs");

    private final String name;

    private SignatureDBType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SignatureDBType getType(String name) {
        for (SignatureDBType type : SignatureDBType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        throw new IllegalArgumentException(name + " cannot be recognised as a SignatureDBType.");
    }
}

