/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.go;

public enum GoAnnotationEvidence {
    IDA("inferred from direct assay", "IDA", "ECO:0000314"),
    IMP("inferred from mutant phenotype", "IMP", "ECO:0000315"),
    IGI("inferred from genetic interaction", "IGI", "ECO:0000316"),
    IPI("inferred from physical interaction", "IPI", "ECO:0000353"),
    IEP("inferred from expression pattern", "IEP", "ECO:0000270"),
    TAS("traceable author statement", "TAS", "ECO:0000304"),
    NAS("non-traceable author statement", "NAS", "ECO:0000303"),
    IC("inferred by curator", "IC", "ECO:0000305"),
    ISS("inferred from sequence similarity", "ISS", "ECO:0000250"),
    IEA("inferred from electronic annotation", "IEA", "ECO:0000501"),
    IGC("inferred from genomic context", "IGC", "ECO:0000317"),
    RCA("inferred from reviewed computational analysis", "RCA", "ECO:0000245"),
    ND("no biological data", "ND", "ECO:0000307"),
    NR("not recorded", "NR", "ECO:0000307"),
    EXP("inferred from experiment", "EXP", "ECO:0000269"),
    IBA("inferred from Biological aspect of Ancestor", "IBA", "ECO:0000318"),
    ISA("inferred from sequence alignment", "ISA", "ECO:0000247"),
    IBD("inferred from Biological aspect of Descendant", "IBD", "ECO:0000319"),
    IKR("inferred from Rapid Divergence", "IKR", "ECO:0000320"),
    IRD("inferred from Rapid Divergence", "IRD", "ECO:0000321"),
    ISO("inferred from Rapid Divergence", "ISO", "ECO:0000266"),
    ISM("inferred from Sequence Model", "ISM", "ECO:0000202"),
    IMR("inferred from missing residues", "IMR", "ECO:0000255"),
    UNKNOWN("Unknown mapping between GO evidence and ECO code", "UNKNOWN", "UNKNOWN");

    private String name;
    private String code;
    private String cvId;

    private GoAnnotationEvidence(String type, String code, String cvId) {
        this.name = type;
        this.code = code;
        this.cvId = cvId;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getCvId() {
        return this.cvId;
    }

    public static GoAnnotationEvidence typeOf(String code) {
        for (GoAnnotationEvidence type : GoAnnotationEvidence.values()) {
            if (!type.getCode().equals(code)) continue;
            return type;
        }
        throw new IllegalArgumentException("the GoAnnotationEvidence with the db Code " + code + " doesn't exist");
    }

    public static GoAnnotationEvidence typeOfcvId(String cvId) {
        GoAnnotationEvidence goEvidence = UNKNOWN;
        if (cvId != null) {
            for (GoAnnotationEvidence type : GoAnnotationEvidence.values()) {
                if (!type.getCvId().equals(cvId)) continue;
                goEvidence = type;
                break;
            }
        }
        return goEvidence;
    }
}

