/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.common.Sequence;

public class SQLineBuilder
extends FFLineBuilderAbstr<Sequence> {
    public SQLineBuilder() {
        super(LineType.SQ);
    }

    @Override
    public String buildString(Sequence f) {
        List<String> lines = this.buildLine(f, false, false);
        return FFLines.create(lines).toString();
    }

    @Override
    public String buildStringWithEvidence(Sequence f) {
        List<String> lines = this.buildLine(f, false, true);
        return FFLines.create(lines).toString();
    }

    @Override
    protected FFLine buildLine(Sequence f, boolean showEvidence) {
        List<String> lines = this.buildLine(f, true, showEvidence);
        return FFLines.create(lines);
    }

    private List<String> buildLine(Sequence f, boolean includeFFMark, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sq = new StringBuilder();
        if (includeFFMark) {
            sq.append(this.linePrefix);
        }
        sq.append("SEQUENCE   ");
        sq.append(f.getLength());
        sq.append(" AA;  ");
        sq.append(f.getMolecularWeight());
        sq.append(" MW;  ");
        sq.append(f.getCRC64());
        sq.append(" CRC64;");
        lines.add(sq.toString());
        String sequence = f.getValue();
        int rowCounter = 0;
        sq = new StringBuilder();
        if (includeFFMark) {
            sq.append("    ");
        }
        for (int i = 0; i < sequence.length(); i += 10) {
            if (rowCounter == 6) {
                lines.add(sq.toString());
                sq = new StringBuilder();
                if (includeFFMark) {
                    sq.append("     ");
                }
                rowCounter = 0;
            } else {
                sq.append(" ");
            }
            if (sequence.length() > i + 10) {
                sq.append(sequence.substring(i, i + 10));
                ++rowCounter;
                continue;
            }
            sq.append(sequence.substring(i));
        }
        if (sq.length() > 0) {
            lines.add(sq.toString());
        }
        return lines;
    }
}

