/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.impl.OGLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;

public class OGLine {
    private static final OGLineBuilder BUILDER = new OGLineBuilder();

    public static String export(UniProtEntry uniProtEntry, boolean withFFMarkup, boolean showEvidence) {
        ArrayList<Organelle> plasmids = null;
        ArrayList<Organelle> ogs = null;
        String ss = "";
        if (!uniProtEntry.getOrganelles().isEmpty()) {
            plasmids = new ArrayList<Organelle>();
            ogs = new ArrayList<Organelle>();
            List<Organelle> organelles = uniProtEntry.getOrganelles();
            for (Organelle organelle : organelles) {
                GeneEncodingType get = organelle.getType();
                if (get == GeneEncodingType.PLASMID) {
                    plasmids.add(organelle);
                    continue;
                }
                ogs.add(organelle);
            }
            if (!ogs.isEmpty()) {
                ss = ss + OGLine.export(ogs, withFFMarkup, showEvidence);
            }
            if (!plasmids.isEmpty()) {
                ss = ss + OGLine.export(plasmids, withFFMarkup, showEvidence);
            }
        }
        return ss;
    }

    private static String export(List<Organelle> organelles, boolean withFFMarkup, boolean showEvidence) {
        if (withFFMarkup) {
            if (showEvidence) {
                return BUILDER.buildWithEvidence(organelles).toString();
            }
            return BUILDER.build(organelles).toString();
        }
        String val = showEvidence ? BUILDER.buildStringWithEvidence(organelles) : BUILDER.buildString(organelles);
        int index = val.indexOf(": ");
        if (index != -1) {
            val = val.substring(index + 2);
        }
        if (val.endsWith(".")) {
            val = val.substring(0, val.length() - 1).trim();
        }
        return val;
    }

    public static String export(Organelle organelle, boolean withFFMarkup) {
        ArrayList<Organelle> orgs = new ArrayList<Organelle>();
        orgs.add(organelle);
        return OGLine.export(orgs, withFFMarkup, true);
    }
}

