/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.plugin.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.sapp.gui.SappAnnotationTransformationConfigurationPanel;
import org.sing_group.seda.sapp.plugin.core.SappAnnotationSedaPluginInfo;
import org.sing_group.seda.sapp.transformation.provider.SappAnnotationTransformationProvider;

public class SappAnnotationSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private SappAnnotationTransformationConfigurationPanel configurationPanel = new SappAnnotationTransformationConfigurationPanel();

    @Override
    public String getName() {
        return "Augustus (SAPP)";
    }

    @Override
    public String getGroupName() {
        return SappAnnotationSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Annotate an eukaryotic genome or sequence of interest by predicting genes using Augustus.";
    }

    @Override
    public Component getEditor() {
        return this.configurationPanel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.configurationPanel.getTransformationProvider();
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<SappAnnotationTransformationProvider>().write(this.configurationPanel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.configurationPanel.setTransformationProvider((SappAnnotationTransformationProvider)new JsonObjectReader().read(file, SappAnnotationTransformationProvider.class));
    }
}

