/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.gui.execution;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.Optional;
import javax.swing.JPanel;
import org.sing_group.gc4s.ui.CardsPanel;
import org.sing_group.gc4s.ui.CardsPanelBuilder;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;
import org.sing_group.seda.sapp.execution.DefaultSappBinariesExecutor;
import org.sing_group.seda.sapp.execution.DockerSappBinariesExecutor;
import org.sing_group.seda.sapp.execution.SappBinariesExecutor;
import org.sing_group.seda.sapp.gui.execution.DockerExecutionConfigurationPanel;
import org.sing_group.seda.sapp.gui.execution.SystemBinaryExecutionConfigurationPanel;

public class SappExecutionConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CARD_SYSTEM_BINARY = "System binary";
    private static final String CARD_DOCKER_IMAGE = "Docker image";
    private CardsPanel sappExecutableCardsPanel;
    private BinaryConfigurationPanelListener<SappBinariesExecutor> sappExecutorChanged;
    private SystemBinaryExecutionConfigurationPanel systemBinaryExecutionConfigurationPanel;
    private DockerExecutionConfigurationPanel dockerExecutionConfigurationPanel;

    public SappExecutionConfigurationPanel(BinaryConfigurationPanelListener<SappBinariesExecutor> binaryConfigurationPanelListener) {
        this.sappExecutorChanged = binaryConfigurationPanelListener;
        this.init();
    }

    private void init() {
        this.systemBinaryExecutionConfigurationPanel = new SystemBinaryExecutionConfigurationPanel();
        this.systemBinaryExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.sappExecutorChanged);
        this.dockerExecutionConfigurationPanel = new DockerExecutionConfigurationPanel();
        this.dockerExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.sappExecutorChanged);
        CardsPanelBuilder builder = CardsPanelBuilder.newBuilder().withCard((Object)CARD_DOCKER_IMAGE, (Component)this.dockerExecutionConfigurationPanel).withSelectedCard(CARD_DOCKER_IMAGE).disableSelectionWithOneCard(true);
        if (!System.getProperty("seda.local.execution.enabled", "true").equals("false") && !System.getProperty("seda.local.execution.enabled.sapp", "true").equals("false")) {
            builder = builder.withCard((Object)CARD_SYSTEM_BINARY, (Component)this.systemBinaryExecutionConfigurationPanel);
        }
        this.sappExecutableCardsPanel = builder.withSelectionLabel("Execution mode").build();
        this.sappExecutableCardsPanel.addPropertyChangeListener("gc4s.cardspanel.visiblecard", this::sappBinaryExecutorCardChanged);
        this.add((Component)this.sappExecutableCardsPanel);
    }

    private void sappBinaryExecutorCardChanged(PropertyChangeEvent event) {
        this.sappExecutorChanged.onBinariesExecutorChanged(this.getSelectedCard());
    }

    public Optional<SappBinariesExecutor> getBinariesExecutor() {
        return this.getSelectedCard().getBinariesExecutor();
    }

    public BinaryExecutionConfigurationPanel<SappBinariesExecutor> getSelectedCard() {
        BinaryExecutionConfigurationPanel selectedCard = (BinaryExecutionConfigurationPanel)((Object)this.sappExecutableCardsPanel.getSelectedCard());
        return selectedCard;
    }

    public void setBinariesExecutor(SappBinariesExecutor binariesExecutor) {
        if (binariesExecutor instanceof DockerSappBinariesExecutor) {
            this.dockerExecutionConfigurationPanel.setSappCommands(((DockerSappBinariesExecutor)binariesExecutor).getDockerSappCommands());
            this.sappExecutableCardsPanel.setSelectedCard((Object)CARD_DOCKER_IMAGE);
        } else if (binariesExecutor instanceof DefaultSappBinariesExecutor) {
            this.systemBinaryExecutionConfigurationPanel.setSappCommands(((DefaultSappBinariesExecutor)binariesExecutor).getSappCommands());
            this.sappExecutableCardsPanel.setSelectedCard((Object)CARD_SYSTEM_BINARY);
        } else {
            throw new IllegalStateException("Unknown BedToolsBinariesExecutor implementation");
        }
    }
}

