/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.cli;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.sing_group.seda.bedtools.cli.BedToolsCommandUtils;
import org.sing_group.seda.cli.ExternalSoftwareExecutionCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.sapp.datatype.SappCodon;
import org.sing_group.seda.sapp.datatype.SappSpecies;
import org.sing_group.seda.sapp.execution.DefaultDockerSappCommands;
import org.sing_group.seda.sapp.execution.DefaultSappBinariesExecutor;
import org.sing_group.seda.sapp.execution.DefaultSappCommands;
import org.sing_group.seda.sapp.execution.DockerSappBinariesExecutor;
import org.sing_group.seda.sapp.execution.SappBinariesExecutor;
import org.sing_group.seda.sapp.execution.SappEnvironment;
import org.sing_group.seda.sapp.plugin.core.SappAnnotationSedaPluginInfo;
import org.sing_group.seda.sapp.transformation.provider.SappAnnotationTransformationProvider;

public class SappAnnotationCommand
extends ExternalSoftwareExecutionCommand {
    public static final DefaultValuedStringOption OPTION_SPECIES = new DefaultValuedStringOption("species", "sp", SappAnnotationSedaPluginInfo.PARAM_SAPP_SPECIES_HELP, SappAnnotationSedaPluginInfo.DEFAULT_SAPP_SPECIES);
    public static final DefaultValuedStringOption OPTION_CODON = new DefaultValuedStringOption("codon-table", "ct", SappAnnotationSedaPluginInfo.PARAM_CODON_HELP, Integer.toString(SappAnnotationSedaPluginInfo.DEFAULT_CODON));
    public static final DefaultValuedStringOption OPTION_DOCKER_MODE = new DefaultValuedStringOption(SOFTWARE_EXECUTION_CATEGORY, "docker-mode", "dk", "The SAPP docker image. By default, the official SEDA image for SAPP is used. If you provide a custom image, it should have Java and the required SAPP jars available at the specified paths.", "singgroup/seda-sapp");
    public static final FlagOption OPTION_LOCAL_MODE = new FlagOption(SOFTWARE_EXECUTION_CATEGORY, "local-mode", "lc", "Whether to use local binaries to run SAPP. You must provide the path to the SAPP jars directory and, optionally, the Java executable path.");
    public static final DefaultValuedStringOption OPTION_JAVA_PATH = new DefaultValuedStringOption(SOFTWARE_EXECUTION_CATEGORY, "java-path", "jp", "The path to the directory that contains the java executable. Leave it empty if the java command is available in the path.", SappAnnotationSedaPluginInfo.DEFAULT_JAVA_PATH);
    public static final StringOption OPTION_SAPP_JARS_PATH = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "sapp-jars-path", "sp", "The path to the directory that contains the SAPP jar files.", true, true);
    public static final StringOption OPTION_BEDTOOLS_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "bedtools-docker-mode", "bedtools-dk", "The bedtools docker image. By default, the official SEDA image for bedtools is used. If you provide a custom image, it should have the bedtools command available in the path.", true, true);
    public static final StringOption OPTION_BEDTOOLS_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "bedtools-local-mode", "bedtools-lc", "The bedtools binary file. If the bedtools binary is in the path, then this can be empty.", true, true);

    public String getName() {
        return "augustus-sapp";
    }

    public String getDescriptiveName() {
        return "Augustus (SAPP)";
    }

    public String getDescription() {
        return "Annotate an eukaryotic genome or sequence of interest by predicting genes using Augustus.";
    }

    @Override
    protected String getSedaGroup() {
        return SappAnnotationSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> getLocalOptionsList() {
        return Arrays.asList(OPTION_LOCAL_MODE);
    }

    @Override
    protected Map<Option<?>, String> getLocalOptionsToEnablePropertyMap() {
        return SappAnnotationCommand.fromLists(Arrays.asList(OPTION_LOCAL_MODE, OPTION_BEDTOOLS_LOCAL_MODE), Arrays.asList("seda.local.execution.enabled.sapp", "seda.local.execution.enabled.bedtools"));
    }

    @Override
    protected List<Option<?>> createExternalSedaOptions() {
        return Arrays.asList(OPTION_SPECIES, OPTION_CODON, OPTION_LOCAL_MODE, OPTION_DOCKER_MODE, OPTION_JAVA_PATH, OPTION_SAPP_JARS_PATH, OPTION_BEDTOOLS_LOCAL_MODE, OPTION_BEDTOOLS_DOCKER_MODE);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        SappAnnotationTransformationProvider provider = new SappAnnotationTransformationProvider();
        provider.setSappCodon(this.getSappCodon(parameters));
        provider.setSappSpecies(SappAnnotationCommand.getEnumValue(parameters, SappSpecies.class, OPTION_SPECIES));
        provider.setSappBinariesExecutor(Optional.of(this.getSappBinariesExecutor(parameters)));
        provider.setBedToolsBinariesExecutor(Optional.of(BedToolsCommandUtils.getBedToolsBinariesExecutor((Parameters)parameters, (StringOption)OPTION_BEDTOOLS_LOCAL_MODE, (StringOption)OPTION_BEDTOOLS_DOCKER_MODE)));
        return provider;
    }

    private SappCodon getSappCodon(Parameters parameters) {
        Optional<SappCodon> codon = Stream.of(SappCodon.values()).filter(c -> c.getParamValue() == Integer.valueOf(parameters.getSingleValueString((Option)OPTION_CODON)).intValue()).findFirst();
        if (codon.isPresent()) {
            return codon.get();
        }
        SappAnnotationCommand.invalidEnumValue(OPTION_CODON);
        throw new RuntimeException();
    }

    private SappBinariesExecutor getSappBinariesExecutor(Parameters parameters) {
        if (parameters.hasFlag((Option)OPTION_LOCAL_MODE)) {
            SappEnvironment sappEnvironment = SappEnvironment.getInstance();
            String javaPath = parameters.getSingleValueString((Option)OPTION_JAVA_PATH);
            if (javaPath.isEmpty()) {
                return new DefaultSappBinariesExecutor(new DefaultSappCommands(parameters.getSingleValueString((Option)OPTION_SAPP_JARS_PATH) + "/" + sappEnvironment.getConversionJar(), parameters.getSingleValueString((Option)OPTION_SAPP_JARS_PATH) + "/" + sappEnvironment.getGeneCallerJar()));
            }
            return new DefaultSappBinariesExecutor(new DefaultSappCommands(javaPath, parameters.getSingleValueString((Option)OPTION_SAPP_JARS_PATH) + "/" + sappEnvironment.getConversionJar(), parameters.getSingleValueString((Option)OPTION_SAPP_JARS_PATH) + "/" + sappEnvironment.getGeneCallerJar()));
        }
        String dockerImage = parameters.getSingleValueString((Option)OPTION_DOCKER_MODE);
        if (dockerImage.equals("singgroup/seda-sapp")) {
            return new DockerSappBinariesExecutor();
        }
        SappEnvironment sappEnvironment = SappEnvironment.getInstance();
        return new DockerSappBinariesExecutor(new DefaultDockerSappCommands(parameters.getSingleValueString((Option)OPTION_JAVA_PATH), parameters.getSingleValueString((Option)OPTION_SAPP_JARS_PATH) + "/" + sappEnvironment.getConversionJar(), parameters.getSingleValueString((Option)OPTION_SAPP_JARS_PATH) + "/" + sappEnvironment.getGeneCallerJar(), dockerImage));
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, SappAnnotationTransformationProvider.class);
    }
}

