/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.google.common.base.Charsets;
import java.io.IOException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class HttpClientUtils {
    public static String getEntityAsStringAndCloseStream(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                String content = EntityUtils.toString((HttpEntity)entity, (String)Charsets.UTF_8.name());
                entity.getContent().close();
                return content;
            }
            catch (IOException | ParseException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return null;
    }

    public static byte[] getEntityAsByteArrayAndCloseStream(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                byte[] content = EntityUtils.toByteArray((HttpEntity)entity);
                entity.getContent().close();
                return content;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return null;
    }
}

