/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.utilities;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class ImageIOUtils {
    public static void toImage(JComponent component, String format, File file) throws IOException {
        int w = component.getWidth();
        int h = component.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g2 = bi.createGraphics();
        component.paint(g2);
        g2.dispose();
        ImageIO.write((RenderedImage)bi, format, file);
    }

    public static void toImage(String format, File file, Component ... components) throws IOException {
        int weight = 0;
        int height = 0;
        for (Component component : components) {
            weight = Math.max(weight, component.getWidth());
            height += component.getHeight();
        }
        List<BufferedImage> bis = ImageIOUtils.toBufferedImages(components);
        BufferedImage bi = new BufferedImage(weight, height, 2);
        Graphics2D g2 = bi.createGraphics();
        int y = 0;
        for (BufferedImage image : bis) {
            int x = (weight - image.getWidth()) / 2;
            g2.drawImage(image, x, y, image.getWidth(), image.getHeight(), null);
            y += image.getHeight();
        }
        g2.dispose();
        ImageIO.write((RenderedImage)bi, format, file);
    }

    private static List<BufferedImage> toBufferedImages(Component ... components) {
        ArrayList<BufferedImage> toret = new ArrayList<BufferedImage>();
        for (Component component : components) {
            BufferedImage bi = new BufferedImage(component.getWidth(), component.getHeight(), 2);
            Graphics2D g2 = bi.createGraphics();
            component.paint(g2);
            g2.dispose();
            toret.add(bi);
        }
        return toret;
    }
}

