/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.filechooser;

import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.sing_group.gc4s.input.filechooser.JMultipleFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.Mode;
import org.sing_group.gc4s.input.filechooser.SelectionMode;

public class JMultipleFileChooserPanelBuilder {
    private Mode mode;
    private JFileChooser fileChooser = new JFileChooser();
    private ImageIcon browseIcon = JMultipleFileChooserPanel.DEFAULT_ICON_BROWSE;
    private SelectionMode selectionMode = JMultipleFileChooserPanel.DEFAULT_SELECTION_MODE;
    private boolean allowAllFilter = true;
    private boolean clearSelectedFileOnShow = false;
    private List<FileFilter> fileFilters = JMultipleFileChooserPanel.DEFAULT_FILE_FILTERS;

    public static JMultipleFileChooserPanelBuilder createOpenJMultipleFileChooserPanel() {
        return new JMultipleFileChooserPanelBuilder(Mode.OPEN);
    }

    public static JMultipleFileChooserPanelBuilder createSaveJMultipleFileChooserPanel() {
        return new JMultipleFileChooserPanelBuilder(Mode.SAVE);
    }

    protected JMultipleFileChooserPanelBuilder(Mode mode) {
        this.mode = mode;
    }

    public JMultipleFileChooserPanelBuilder withFileChooser(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
        return this;
    }

    public JMultipleFileChooserPanelBuilder withBrowseIcon(ImageIcon browseIcon) {
        this.browseIcon = browseIcon;
        return this;
    }

    public JMultipleFileChooserPanelBuilder withFileChooserSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        return this;
    }

    public JMultipleFileChooserPanelBuilder withAllowAllFilter(boolean allowAllFilter) {
        this.allowAllFilter = allowAllFilter;
        return this;
    }

    public JMultipleFileChooserPanelBuilder withClearSelectedFileOnShow(boolean clearSelectedFileOnShow) {
        this.clearSelectedFileOnShow = clearSelectedFileOnShow;
        return this;
    }

    public JMultipleFileChooserPanelBuilder withFileFilters(List<FileFilter> fileFilters) {
        this.fileFilters = fileFilters;
        return this;
    }

    public JMultipleFileChooserPanel build() {
        return new JMultipleFileChooserPanel(this.mode, this.fileChooser, this.browseIcon, this.selectionMode, this.allowAllFilter, this.clearSelectedFileOnShow, this.fileFilters);
    }
}

