/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input;

import java.awt.Color;
import java.text.ParseException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.sing_group.gc4s.input.DoubleRange;

public class DoubleRangeSpinnerInputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_RANGE = "value";
    public static final Color COLOR_INVALID_INPUT = new Color(255, 148, 148);
    public static final Color COLOR_VALID_INPUT = UIManager.getColor("TextField.background");
    private ChangeListener listener = this::rangeChanged;
    private DoubleRange oldRange;
    private double min;
    private double max;
    private double rangeStart;
    private double rangeEnd;
    private double step;
    private JSpinner rangeStartSpinner;
    private JSpinner rangeEndSpinner;
    private JLabel startLabel;
    private JLabel endLabel;

    public DoubleRangeSpinnerInputPanel(double min, double max, double rangeStart, double rangeEnd, double step) {
        this.min = min;
        this.max = max;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.step = step;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.getStartLabel());
        this.add(this.getRangeStartSpinner());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.getEndLabel());
        this.add(this.getRangeEndSpinner());
    }

    private JLabel getStartLabel() {
        this.startLabel = new JLabel("Start:");
        return this.startLabel;
    }

    private JLabel getEndLabel() {
        this.endLabel = new JLabel("End:");
        return this.endLabel;
    }

    private JSpinner getRangeStartSpinner() {
        this.rangeStartSpinner = new JSpinner(new SpinnerNumberModel(this.rangeStart, this.min, this.max, this.step));
        this.rangeStartSpinner.addChangeListener(this.listener);
        this.configureTextField(this.rangeStartSpinner);
        return this.rangeStartSpinner;
    }

    protected void configureTextField(JSpinner spinner) {
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, "0.0#####");
        JFormattedTextField textField = editor.getTextField();
        textField.setColumns(5);
        spinner.setEditor(editor);
    }

    private JSpinner getRangeEndSpinner() {
        this.rangeEndSpinner = new JSpinner(new SpinnerNumberModel(this.rangeEnd, this.min, this.max, this.step));
        this.rangeEndSpinner.addChangeListener(this.listener);
        this.configureTextField(this.rangeEndSpinner);
        return this.rangeEndSpinner;
    }

    private void checkRangeValues() {
        boolean validRange = this.isValidRange();
        this.setRangeTextFieldColor(validRange);
    }

    private void setRangeTextFieldColor(boolean validValues) {
        Color backgroundColor = this.getTextFieldBackgroundColor(validValues);
        ((JSpinner.NumberEditor)this.rangeStartSpinner.getEditor()).getTextField().setBackground(backgroundColor);
        ((JSpinner.NumberEditor)this.rangeEndSpinner.getEditor()).getTextField().setBackground(backgroundColor);
    }

    private Color getTextFieldBackgroundColor(boolean validValues) {
        return validValues ? COLOR_VALID_INPUT : COLOR_INVALID_INPUT;
    }

    public boolean isValidRange() {
        return this.getMinValue() <= this.getMaxValue();
    }

    private double getMinValue() {
        return DoubleRangeSpinnerInputPanel.getSpinnerValue(this.rangeStartSpinner);
    }

    protected static double getSpinnerValue(JSpinner spinner) {
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        try {
            return editor.getFormat().parse(editor.getTextField().getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    private double getMaxValue() {
        return DoubleRangeSpinnerInputPanel.getSpinnerValue(this.rangeEndSpinner);
    }

    public DoubleRange getRange() {
        return new DoubleRange(this.getMinValue(), this.getMaxValue());
    }

    private void rangeChanged(ChangeEvent e) {
        DoubleRange newRange = this.getRange();
        this.firePropertyChange(PROPERTY_RANGE, this.oldRange, newRange);
        this.oldRange = newRange;
        this.checkRangeValues();
    }

    public void setStartLabel(String label) {
        this.startLabel.setText(label);
    }

    public void setEndLabel(String label) {
        this.endLabel.setText(label);
    }

    public void setSelectedRange(DoubleRange range) {
        this.validateRange(range);
        this.rangeStartSpinner.setValue(range.getMin());
        this.rangeEndSpinner.setValue(range.getMax());
    }

    private void validateRange(DoubleRange range) {
        if (range.getMax() > this.max) {
            throw new IllegalArgumentException("Can't set a range end value higher than the component maximum value (" + this.max + ")");
        }
        if (range.getMin() < this.min) {
            throw new IllegalArgumentException("Can't set a range start value higher than the component minimum value (" + this.min + ")");
        }
    }
}

