/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.gui;

import java.awt.event.ItemEvent;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.RunnableDocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.seda.cga.execution.CgaCompiPipelineConfiguration;
import org.sing_group.seda.cga.plugin.core.CgaPipelineSedaPluginInfo;

public class CgaCompiPipelineConfigurationParameters {
    private JIntegerTextField maxDist;
    private JIntegerTextField intronBp;
    private JIntegerTextField minFullNucleotideSize;
    private JComboBox<CgaCompiPipelineConfiguration.SelectionCriterion> selectionCriterion;
    private JIntegerTextField selectionCorrection;
    private JCheckBox skipPullDockerImages;
    private Runnable onConfigurationChanged;

    public CgaCompiPipelineConfigurationParameters(Runnable onConfigurationChanged) {
        this.onConfigurationChanged = onConfigurationChanged;
    }

    public InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getMaxDistParameter());
        parameters.add(this.getIntronBpParameter());
        parameters.add(this.getMinFullNucleotideSizeParameter());
        parameters.add(this.getSelectionCriterionParameter());
        parameters.add(this.getSelectionCorrectionParameter());
        parameters.add(this.getSkipPullDockerImagesParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getMaxDistParameter() {
        this.maxDist = new JIntegerTextField(Integer.valueOf(10000));
        this.maxDist.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this.onConfigurationChanged));
        return new InputParameter("Max. dist.:", (JComponent)this.maxDist, CgaPipelineSedaPluginInfo.PARAM_MAX_DIST_HELP_GUI);
    }

    private InputParameter getIntronBpParameter() {
        this.intronBp = new JIntegerTextField(Integer.valueOf(100));
        this.intronBp.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this.onConfigurationChanged));
        return new InputParameter("Intron BP:", (JComponent)this.intronBp, "Distance around the junction point between two sequences where to look for splicing signals.");
    }

    private InputParameter getMinFullNucleotideSizeParameter() {
        this.minFullNucleotideSize = new JIntegerTextField(Integer.valueOf(100));
        this.minFullNucleotideSize.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this.onConfigurationChanged));
        return new InputParameter("Min. CDS size:", (JComponent)this.minFullNucleotideSize, "Minimum size for CDS to be reported.");
    }

    private InputParameter getSelectionCriterionParameter() {
        this.selectionCriterion = new JComboBox<CgaCompiPipelineConfiguration.SelectionCriterion>(CgaCompiPipelineConfiguration.SelectionCriterion.values());
        this.selectionCriterion.setSelectedItem((Object)CgaCompiPipelineConfiguration.DEFAULT_SELECTION_CRITERION);
        this.selectionCriterion.addItemListener(this::selectionCriterionChanged);
        return new InputParameter("Selection criterion: ", this.selectionCriterion, CgaPipelineSedaPluginInfo.PARAM_MIN_SELECTION_CRITERION_HELP_GUI);
    }

    private void selectionCriterionChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(this.onConfigurationChanged);
        }
    }

    private InputParameter getSelectionCorrectionParameter() {
        this.selectionCorrection = new JIntegerTextField(Integer.valueOf(0));
        this.selectionCorrection.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this.onConfigurationChanged));
        return new InputParameter("Selection correction:", (JComponent)this.selectionCorrection, "A bonus percentage times 10 when using the mixed selection model (3). For instance, 20 means 2% bonus. Something with 18% similarity acts as having 20% similarity.");
    }

    private InputParameter getSkipPullDockerImagesParameter() {
        this.skipPullDockerImages = new JCheckBox();
        this.skipPullDockerImages.addItemListener(this::skipPullDockerImagesChanged);
        return new InputParameter("Skip pull Docker images:", (JComponent)this.skipPullDockerImages, CgaPipelineSedaPluginInfo.PARAM_SKIP_PULL_DOCKER_IMAGES_HELP_GUI);
    }

    private void skipPullDockerImagesChanged(ItemEvent event) {
        SwingUtilities.invokeLater(this.onConfigurationChanged);
    }

    public CgaCompiPipelineConfiguration getConfiguration() {
        return new CgaCompiPipelineConfiguration(this.maxDist.getValue(), this.intronBp.getValue(), this.minFullNucleotideSize.getValue(), (CgaCompiPipelineConfiguration.SelectionCriterion)((Object)this.selectionCriterion.getSelectedItem()), this.selectionCorrection.getValue(), this.skipPullDockerImages.isSelected());
    }

    public void setConfiguration(CgaCompiPipelineConfiguration cgaCompiPipelineConfiguration) {
        this.intronBp.setValue((Object)cgaCompiPipelineConfiguration.getIntronBp());
        this.maxDist.setValue((Object)cgaCompiPipelineConfiguration.getMaxDist());
        this.minFullNucleotideSize.setValue((Object)cgaCompiPipelineConfiguration.getMinFullNucleotideSize());
        this.selectionCorrection.setValue((Object)cgaCompiPipelineConfiguration.getSelectionCorrection());
        if (cgaCompiPipelineConfiguration.getSelectionCriterion() != null) {
            this.selectionCriterion.setSelectedItem((Object)cgaCompiPipelineConfiguration.getSelectionCriterion());
        }
        this.skipPullDockerImages.setSelected(cgaCompiPipelineConfiguration.isSkipPullDockerImages());
        SwingUtilities.invokeLater(this.onConfigurationChanged);
    }
}

