/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.core.execution.AbstractBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.prosplign.execution.ProSplignCompartBinariesChecker;
import org.sing_group.seda.prosplign.execution.ProSplignCompartBinariesExecutor;

public abstract class AbstractProSplignCompartBinariesExecutor
extends AbstractBinariesExecutor
implements ProSplignCompartBinariesExecutor {
    @Override
    public void checkBinary() throws BinaryCheckException {
        ProSplignCompartBinariesChecker.checkProSplignCompartPath(this::composeCommand);
    }

    protected abstract String composeCommand(String var1);

    protected abstract String toFilePath(File var1);

    protected void proSplign(List<String> proSplignCommand, File compart, File nucleotidesFasta, File proteinQueryFasta, File outputDir, String outputFileName) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(proSplignCommand);
        parameters.addAll(Arrays.asList("-i", this.toFilePath(compart), "-fasta", this.toFilePath(nucleotidesFasta) + "," + this.toFilePath(proteinQueryFasta), "-nogenbank", "-o", this.toFilePath(new File(outputDir, outputFileName + ".asn")), "-eo", this.toFilePath(new File(outputDir, outputFileName + ".txt"))));
        this.executeCommand(parameters);
    }

    protected void proCompart(List<String> proCompartcommand, File database, File outputFile) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(proCompartcommand);
        parameters.addAll(Arrays.asList(this.toFilePath(database), this.toFilePath(outputFile)));
        this.executeCommand(parameters);
    }
}

