/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.pfam.cli;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.pfam.PfamScanSequenceErrorPolicy;
import org.sing_group.seda.pfam.core.PfamScanSedaPluginInfo;
import org.sing_group.seda.pfam.transformations.provider.PfamScanTransformationProvider;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class PfamScanCommand
extends SedaCommand {
    public static final StringOption OPTION_EMAIL = new StringOption("email", "em", PfamScanSedaPluginInfo.PARAM_EMAIL_HELP, true, true);
    public static final FlagOption OPTION_ACTIVE_SITE_PREDICTION = new FlagOption("active-site-prediction", "asp", "Whether to predict active site residues for Pfam-A matches or not.");
    public static final DefaultValuedStringOption OPTION_EVALUE = new DefaultValuedStringOption("evalue", "ev", "Optionally, the expectation value cut-off.", Double.toString(10.0));
    public static final DefaultValuedStringOption OPTION_ERROR_POLICY = new DefaultValuedStringOption("error-policy", "ep", PfamScanSedaPluginInfo.PARAM_ERROR_POLICY_HELP, PfamScanSedaPluginInfo.DEFAULT_ERROR_POLICY.name().toLowerCase());
    public static final IntegerDefaultValuedStringConstructedOption OPTION_BATCH_DELAY_FACTOR = new IntegerDefaultValuedStringConstructedOption("batch-delay-factor", "bdf", "The delay factor between batches. SEDA runs PfamScan queries in batches of 30 sequences to meet the EMBL-EBI guidelines regarding the usage of resources. A delay factor of 1 means that SEDA waits a time between batches equal to the time required to analyze the first batch.", Integer.valueOf(1));

    public String getName() {
        return "pfamscan";
    }

    public String getDescriptiveName() {
        return "PfamScan";
    }

    public String getDescription() {
        return "Search and annotate sequences against the Pfam-A HMM library using the EMBL-EBI web service (https://www.ebi.ac.uk/Tools/pfa/pfamscan/).";
    }

    @Override
    protected String getSedaGroup() {
        return PfamScanSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_EMAIL);
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        return Arrays.asList(OPTION_EMAIL, OPTION_ACTIVE_SITE_PREDICTION, OPTION_EVALUE, OPTION_ERROR_POLICY, OPTION_BATCH_DELAY_FACTOR);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        PfamScanTransformationProvider provider = new PfamScanTransformationProvider();
        provider.setEmail(parameters.getSingleValueString((Option)OPTION_EMAIL));
        if (parameters.hasFlag((Option)OPTION_ACTIVE_SITE_PREDICTION)) {
            provider.setActiveSitePrediction(true);
        }
        if (parameters.hasOption((Option)OPTION_EVALUE)) {
            provider.setEvalue(PfamScanCommand.getDoubleValue(parameters, (Option<String>)OPTION_EVALUE));
        }
        if (parameters.hasOption((Option)OPTION_ERROR_POLICY)) {
            provider.setErrorPolicy(PfamScanCommand.getEnumValue(parameters, PfamScanSequenceErrorPolicy.class, OPTION_ERROR_POLICY));
        }
        if (parameters.hasOption((Option)OPTION_BATCH_DELAY_FACTOR)) {
            provider.setBatchDelayFactor((Integer)parameters.getSingleValue((Option)OPTION_BATCH_DELAY_FACTOR));
        }
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, PfamScanTransformationProvider.class);
    }
}

