/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.core.trim.SequenceAlignmentGapsBoundaries;
import org.sing_group.seda.core.trim.StringTrimmer;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class TrimAlignmentSequencesGroupTransformation
implements SequencesGroupTransformation {
    private final SequencesGroupBuilder builder = factory::newSequencesGroup;
    private final SequenceBuilder sequenceBuilder = factory::newSequence;

    public TrimAlignmentSequencesGroupTransformation() {
        this(DatatypeFactory.getDefaultDatatypeFactory());
    }

    public TrimAlignmentSequencesGroupTransformation(DatatypeFactory factory) {
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        List boundaries = sequencesGroup.getSequences().map(SequenceAlignmentGapsBoundaries::new).collect(Collectors.toList());
        int leading = boundaries.stream().mapToInt(SequenceAlignmentGapsBoundaries::leadingBases).max().getAsInt();
        int trailing = boundaries.stream().mapToInt(SequenceAlignmentGapsBoundaries::trailingBases).max().getAsInt();
        StringTrimmer trimmer = new StringTrimmer(leading, trailing);
        List<Sequence> trimmedSequences = sequencesGroup.getSequences().map(s -> this.sequenceBuilder.of(s.getName(), s.getDescription(), trimmer.trim(s.getChain()), s.getProperties())).collect(Collectors.toList());
        return this.builder.of(sequencesGroup.getName(), sequencesGroup.getProperties(), trimmedSequences);
    }
}

