/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.bio.SequenceUtils;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class RemoveRedundantSequencesTransformation
implements SequencesGroupTransformation {
    private static final Mode DEFAULT_MODE = Mode.EXACT_DUPLICATES;
    private static final boolean DEFAULT_MERGE_HEADERS = false;
    private static final Comparator<? super Sequence> SEQUENCE_COMPARATOR = new Comparator<Sequence>(){

        @Override
        public int compare(Sequence o1, Sequence o2) {
            int comparison = o2.getChain().length() - o1.getChain().length();
            return comparison == 0 ? o2.getChain().compareTo(o1.getChain()) : comparison;
        }
    };
    private final SequenceBuilder sequenceBuilder;
    private final SequencesGroupBuilder groupBuilder;
    private final Mode mode;
    private boolean mergeHeaders;
    private File mergedSequencesListDirectory;
    private Optional<SequenceTranslationConfiguration> translationConfiguration;

    public RemoveRedundantSequencesTransformation() {
        this(new RemoveRedundantSequencesTransformationConfiguration(DEFAULT_MODE, false));
    }

    public RemoveRedundantSequencesTransformation(RemoveRedundantSequencesTransformationConfiguration configuration) {
        this(configuration, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public RemoveRedundantSequencesTransformation(RemoveRedundantSequencesTransformationConfiguration configuration, SequenceTranslationConfiguration translationConfiguration) {
        this(configuration, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public RemoveRedundantSequencesTransformation(RemoveRedundantSequencesTransformationConfiguration configuration, DatatypeFactory factory) {
        this.mode = configuration.getMode();
        this.translationConfiguration = configuration.getSequenceTranslationConfiguration();
        this.mergeHeaders = configuration.isMergeHeaders();
        if (configuration.getMergedSequencesListDirectory().isPresent()) {
            this.mergedSequencesListDirectory = configuration.getMergedSequencesListDirectory().get();
        }
        this.groupBuilder = factory::newSequencesGroup;
        this.sequenceBuilder = factory::newSequence;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        HashMap<String, List<String>> mergedSequences = new HashMap<String, List<String>>();
        List<Sequence> sortedSequences = this.sortBySequenceLength(sequencesGroup);
        TreeSet<Sequence> filteredSequences = new TreeSet<Sequence>(SEQUENCE_COMPARATOR);
        for (Sequence inputSequence : sortedSequences) {
            Optional<Sequence> match = this.currentSequenceIsRedundant(inputSequence, filteredSequences);
            if (match.isPresent()) {
                Sequence matchSequence = match.get();
                String matchSequenceHeader = matchSequence.getHeader();
                mergedSequences.putIfAbsent(matchSequenceHeader, new LinkedList());
                StringBuilder inputSequenceHeaderSb = new StringBuilder(inputSequence.getName().replace(">", ""));
                if (!inputSequence.getDescription().isEmpty()) {
                    inputSequenceHeaderSb.append(" ").append(inputSequence.getDescription());
                }
                String inputSequenceHeader = inputSequenceHeaderSb.toString();
                ((List)mergedSequences.get(matchSequenceHeader)).add(inputSequenceHeader);
                if (!this.mergeHeaders) continue;
                StringBuilder newDescriptionSb = new StringBuilder();
                if (!matchSequence.getDescription().isEmpty()) {
                    newDescriptionSb.append(matchSequence.getDescription()).append(" ");
                }
                newDescriptionSb.append("[").append(inputSequenceHeader).append("]");
                filteredSequences.remove(matchSequence);
                Sequence mergedSequence = this.sequenceBuilder.of(matchSequence.getName(), newDescriptionSb.toString(), matchSequence.getChain(), matchSequence.getProperties());
                filteredSequences.add(mergedSequence);
                continue;
            }
            filteredSequences.add(inputSequence);
        }
        if (this.mergedSequencesListDirectory != null) {
            this.saveMergedSequences(mergedSequences, sequencesGroup.getName());
        }
        return this.groupBuilder.of(sequencesGroup.getName(), sequencesGroup.getProperties(), new LinkedList<Sequence>(filteredSequences));
    }

    private void saveMergedSequences(Map<String, List<String>> mergedSequences, String groupName) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : mergedSequences.entrySet()) {
            List<String> values = entry.getValue();
            if (values.isEmpty()) continue;
            sb.append("\"").append(entry.getKey().substring(1)).append("\" replaces the following sequences:").append(System.lineSeparator());
            values.forEach(v -> sb.append("\t").append((String)v).append(System.lineSeparator()));
            sb.append(System.lineSeparator());
        }
        try {
            this.mergedSequencesListDirectory.mkdirs();
            Files.write(new File(this.mergedSequencesListDirectory, groupName + "_merge-list.txt").toPath(), sb.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Optional<Sequence> currentEvaluableSequenceIsRedundant(EvaluableSequence inputSequence, Set<EvaluableSequence> filteredSequences) {
        for (EvaluableSequence filteredSequence : filteredSequences) {
            for (int i = 0; i < filteredSequence.count(); ++i) {
                String filteredSequenceChain;
                String inputSequenceChain = inputSequence.get(i);
                if (inputSequenceChain.equals(filteredSequenceChain = filteredSequence.get(i))) {
                    return Optional.of(filteredSequence.getSequence());
                }
                if (!this.mode.equals((Object)Mode.CONTAINED_SEQUENCES) || !filteredSequenceChain.contains(inputSequenceChain)) continue;
                return Optional.of(filteredSequence.getSequence());
            }
            if (inputSequence.length() <= filteredSequence.length()) continue;
            break;
        }
        return Optional.empty();
    }

    private Optional<Sequence> currentSequenceIsRedundant(Sequence inputSequence, Set<Sequence> filteredSequences) {
        return this.currentEvaluableSequenceIsRedundant(this.asEvaluableSequence(inputSequence), this.asEvaluableSequences(filteredSequences));
    }

    private EvaluableSequence asEvaluableSequence(Sequence sequence) {
        if (this.translationConfiguration.isPresent()) {
            return new EvaluableSequence(sequence, this.translationConfiguration.get());
        }
        return new EvaluableSequence(sequence);
    }

    private Set<EvaluableSequence> asEvaluableSequences(Set<Sequence> filteredSequences) {
        TreeSet<EvaluableSequence> evaluableSequences = new TreeSet<EvaluableSequence>(new Comparator<EvaluableSequence>(){

            @Override
            public int compare(EvaluableSequence o1, EvaluableSequence o2) {
                int comparison = o2.getSequence().getChain().length() - o1.getSequence().getChain().length();
                return comparison == 0 ? o2.getSequence().getChain().compareTo(o1.getSequence().getChain()) : comparison;
            }
        });
        filteredSequences.forEach(s -> evaluableSequences.add(this.asEvaluableSequence((Sequence)s)));
        return evaluableSequences;
    }

    private List<Sequence> sortBySequenceLength(SequencesGroup sequencesGroup) {
        LinkedList<Sequence> sorted = new LinkedList<Sequence>();
        sorted.addAll(sequencesGroup.getSequences().collect(Collectors.toList()));
        Collections.sort(sorted, SEQUENCE_COMPARATOR);
        return sorted;
    }

    private static class EvaluableSequence {
        List<String> evaluableChains;
        private Sequence sequence;

        public EvaluableSequence(Sequence sequence, SequenceTranslationConfiguration translationConfiguration) {
            this.sequence = sequence;
            this.evaluableChains = new LinkedList<String>();
            for (int frame : translationConfiguration.getFrames()) {
                this.evaluableChains.add(this.translate(sequence.getChain(), frame, translationConfiguration));
            }
        }

        private String translate(String chain, int frame, SequenceTranslationConfiguration translationConfiguration) {
            return SequenceUtils.translate(chain, translationConfiguration.isReverseComplement(), frame, translationConfiguration.getCodonTable());
        }

        public EvaluableSequence(Sequence sequence) {
            this.sequence = sequence;
            this.evaluableChains = new LinkedList<String>(Arrays.asList(sequence.getChain()));
        }

        public int count() {
            return this.evaluableChains.size();
        }

        public String get(int i) {
            return this.evaluableChains.get(i);
        }

        public Sequence getSequence() {
            return this.sequence;
        }

        public int length() {
            return this.sequence.getLength();
        }
    }

    @XmlRootElement
    public static class RemoveRedundantSequencesTransformationConfiguration {
        @XmlElement
        private Mode mode;
        @XmlElement
        private boolean mergeHeaders;
        @XmlElement
        private File mergedSequences;
        @XmlElement
        private SequenceTranslationConfiguration sequenceTranslationConfiguration;

        public RemoveRedundantSequencesTransformationConfiguration() {
        }

        public RemoveRedundantSequencesTransformationConfiguration(Mode mode, boolean mergeHeaders) {
            this(mode, mergeHeaders, null, null);
        }

        public RemoveRedundantSequencesTransformationConfiguration(Mode mode, boolean mergeHeaders, SequenceTranslationConfiguration sequenceTranslationConfiguration) {
            this(mode, mergeHeaders, null, sequenceTranslationConfiguration);
        }

        public RemoveRedundantSequencesTransformationConfiguration(Mode mode, boolean mergeHeaders, File mergedSequencesListDirectory) {
            this(mode, mergeHeaders, mergedSequencesListDirectory, null);
        }

        public RemoveRedundantSequencesTransformationConfiguration(Mode mode, boolean mergeHeaders, File mergedSequencesListDirectory, SequenceTranslationConfiguration sequenceTranslationConfiguration) {
            this.mode = mode;
            this.mergeHeaders = mergeHeaders;
            this.mergedSequences = mergedSequencesListDirectory;
            this.sequenceTranslationConfiguration = sequenceTranslationConfiguration;
        }

        public Mode getMode() {
            return this.mode;
        }

        public boolean isMergeHeaders() {
            return this.mergeHeaders;
        }

        public Optional<File> getMergedSequencesListDirectory() {
            return Optional.ofNullable(this.mergedSequences);
        }

        public Optional<SequenceTranslationConfiguration> getSequenceTranslationConfiguration() {
            return Optional.ofNullable(this.sequenceTranslationConfiguration);
        }
    }

    public static enum Mode {
        EXACT_DUPLICATES,
        CONTAINED_SEQUENCES;

    }
}

