/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class GrowSequencesGroupTransformation
implements SequencesGroupTransformation {
    private final SequenceBuilder seqBuilder = factory::newSequence;
    private final SequencesGroupBuilder builder = factory::newSequencesGroup;
    private int minimumOverlapping;

    public GrowSequencesGroupTransformation(int minimumOverlapping) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), minimumOverlapping);
    }

    public GrowSequencesGroupTransformation(DatatypeFactory factory, int minimumOverlapping) {
        this.minimumOverlapping = minimumOverlapping;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        return this.builder.of(sequencesGroup.getName(), sequencesGroup.getProperties(), this.mergeOverlappingSequences(sequencesGroup));
    }

    private List<Sequence> mergeOverlappingSequences(SequencesGroup sequencesGroup) {
        List<Sequence> sequences = sequencesGroup.getSequences().collect(Collectors.toList());
        boolean shouldIterate = false;
        block0: do {
            shouldIterate = false;
            for (int i = 0; i < sequences.size(); ++i) {
                Sequence reference = (Sequence)sequences.get(i);
                if (reference.getChain().length() < this.minimumOverlapping) continue;
                String referenceChain = reference.getChain();
                for (int j = 0; j < sequences.size(); ++j) {
                    String compareChain;
                    String overlappingPart;
                    Sequence compare;
                    if (i == j || (compare = sequences.get(j)).getChain().length() < this.minimumOverlapping || (overlappingPart = GrowSequencesGroupTransformation.computeDifferentialOverlapping(referenceChain, compareChain = compare.getChain(), this.minimumOverlapping)).length() < this.minimumOverlapping) continue;
                    String mergedChain = compareChain.substring(0, compareChain.length() - overlappingPart.length()) + referenceChain;
                    String mergedDescription = (reference.getDescription().isEmpty() ? "[" : reference.getDescription() + " [") + compare.getName() + (compare.getDescription().isEmpty() ? "" : " ") + compare.getDescription() + "]";
                    Sequence merged = this.seqBuilder.of(reference.getName(), mergedDescription, mergedChain, reference.getProperties());
                    sequences.remove(compare);
                    sequences.remove(reference);
                    sequences.add(merged);
                    shouldIterate = true;
                    break;
                }
                if (shouldIterate) continue block0;
            }
        } while (shouldIterate);
        return sequences;
    }

    private static String computeDifferentialOverlapping(String atBeginning, String atEnding, int minimumSize) {
        int size = minimumSize;
        String overlapping = "";
        do {
            String subB;
            String subA;
            if (!(subA = atBeginning.substring(0, size)).equals(subB = atEnding.substring(atEnding.length() - size, atEnding.length()))) continue;
            overlapping = subA;
        } while (++size <= atBeginning.length() && size <= atEnding.length());
        return overlapping;
    }
}

