/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.merge;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.TransformationChangeEvent;
import org.sing_group.seda.plugin.spi.TransformationChangeListener;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.MergeSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.merge.MergeTransformationChangeType;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;

@XmlRootElement
public class MergeTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private String name = null;
    @XmlElement
    private ReformatFastaTransformationProvider reformatFastaTransformationProvider;
    private TransformationChangeListener reformatFastaTransformationChangeListener = new TransformationChangeListener(){

        @Override
        public void onTransformationChange(TransformationChangeEvent event) {
            MergeTransformationProvider.this.fireTransformationsConfigurationModelEvent(event);
        }
    };

    @Override
    public Validation validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.name == null) {
            errors.add("The name can't be null.");
        } else if (this.name.isEmpty()) {
            errors.add("The name can't be empty.");
        }
        errors.addAll(this.reformatFastaTransformationProvider.validate().getValidationErrors());
        if (errors.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(errors);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return SequencesGroupDatasetTransformation.concat(new MergeSequencesGroupDatasetTransformation(this.getName()), this.reformatFastaTransformationProvider.getTransformation(factory));
    }

    public void setName(String name) {
        if (this.name == null || !this.name.equals(name)) {
            this.name = name;
            this.fireTransformationsConfigurationModelEvent(MergeTransformationChangeType.NAME_CHANGED, this.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public ReformatFastaTransformationProvider getReformatFastaTransformationProvider() {
        return this.reformatFastaTransformationProvider;
    }

    public void setReformatFastaTransformationProvider(ReformatFastaTransformationProvider reformatFastaTransformationProvider) {
        this.reformatFastaTransformationProvider = reformatFastaTransformationProvider;
        this.reformatFastaTransformationProvider.addTransformationChangeListener(this.reformatFastaTransformationChangeListener);
    }
}

