/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.isoforms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.seda.core.rename.EmptySequenceHeadersJoiner;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.core.rename.SequenceHeadersJoiner;
import org.sing_group.seda.plugin.core.info.plugin.RemoveIsoformsSedaPluginInfo;

public class RemovedIsoformHeadersConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_DELIMITER = ", ";
    private static final String DEFAULT_PREFIX = "[";
    private static final String DEFAULT_SUFFIX = "]";
    public static final String DESCRIPTION_ADD_HEADERS = RemoveIsoformsSedaPluginInfo.PARAM_REMOVE_ISOFORM_HEADER_HELP_GUI;
    public static final String DESCRIPTION_HEADER_TARGET = RemoveIsoformsSedaPluginInfo.PARAM_HEADER_TARGET_HELP_GUI;
    public static final boolean DEFAULT_ADD_REMOVED_ISOFORM_HEADERS = false;
    public static final HeaderTarget DEFAULT_HEADER_TARGET = RemoveIsoformsSedaPluginInfo.DEFAULT_REMOVE_ISOFORM_HEADER_TARGET;
    public static final String PROPERTY_ADD_REMOVED_ISOFORM_HEADERS = "property.add.headers";
    public static final String PROPERTY_HEADER_TARGET = "property.header.target";
    public static final Set<String> PROPERTIES = new HashSet<String>(Arrays.asList("property.header.target", "property.add.headers"));
    private JCheckBox addRemovedIsoformHeadersCb;
    private JComboBox<HeaderTarget> headerTargetComboBox;
    private boolean oldReferenceSizeValue = false;
    private HeaderTarget oldHeaderTargetValue = DEFAULT_HEADER_TARGET;
    private InputParameter[] additionalParameters;

    public RemovedIsoformHeadersConfigurationPanel(InputParameter ... additionalParameters) {
        this.additionalParameters = additionalParameters;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)new InputParametersPanel(this.getInputParameters()));
    }

    private InputParameter[] getInputParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getAddRemovedIsoformHeadersParameter());
        parameters.add(this.getHeaderTargetParameter());
        parameters.addAll(Arrays.asList(this.additionalParameters));
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getAddRemovedIsoformHeadersParameter() {
        this.addRemovedIsoformHeadersCb = new JCheckBox("Add removed isoform headers?");
        this.addRemovedIsoformHeadersCb.addItemListener(this::removedIsoformHeadersChanged);
        return new InputParameter("", (JComponent)this.addRemovedIsoformHeadersCb, DESCRIPTION_ADD_HEADERS);
    }

    private void removedIsoformHeadersChanged(ItemEvent event) {
        boolean newValue = this.isAddRemovedIsoformHeaders();
        this.firePropertyChange(PROPERTY_ADD_REMOVED_ISOFORM_HEADERS, this.oldReferenceSizeValue, newValue);
        this.oldReferenceSizeValue = newValue;
    }

    private boolean isAddRemovedIsoformHeaders() {
        return this.addRemovedIsoformHeadersCb.isSelected();
    }

    private InputParameter getHeaderTargetParameter() {
        this.headerTargetComboBox = new JComboBox<HeaderTarget>(HeaderTarget.values());
        this.headerTargetComboBox.setSelectedItem((Object)DEFAULT_HEADER_TARGET);
        this.headerTargetComboBox.addItemListener(this::headerTargetChanged);
        return new InputParameter("Header target:", this.headerTargetComboBox, DESCRIPTION_HEADER_TARGET);
    }

    private void headerTargetChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            HeaderTarget newValue = this.getHeaderTarget();
            this.firePropertyChange(PROPERTY_HEADER_TARGET, (Object)this.oldHeaderTargetValue, (Object)newValue);
            this.oldHeaderTargetValue = newValue;
        }
    }

    private HeaderTarget getHeaderTarget() {
        return (HeaderTarget)((Object)this.headerTargetComboBox.getSelectedItem());
    }

    public SequenceHeadersJoiner getSequenceHeadersJoiner() {
        if (this.isAddRemovedIsoformHeaders()) {
            return new SequenceHeadersJoiner(this.getHeaderTarget(), DEFAULT_DELIMITER, DEFAULT_PREFIX, DEFAULT_SUFFIX);
        }
        return new EmptySequenceHeadersJoiner();
    }

    public void setSequenceHeadersJoiner(SequenceHeadersJoiner sequenceHeadersJoiner) {
        if (sequenceHeadersJoiner instanceof EmptySequenceHeadersJoiner) {
            this.addRemovedIsoformHeadersCb.setSelected(false);
        } else if (sequenceHeadersJoiner instanceof SequenceHeadersJoiner) {
            this.addRemovedIsoformHeadersCb.setSelected(true);
            this.headerTargetComboBox.setSelectedItem((Object)sequenceHeadersJoiner.getTarget());
        } else {
            throw new IllegalArgumentException("Unsupported class " + sequenceHeadersJoiner.getClass());
        }
    }
}

