/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.rename;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.rename.AbstractHeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.util.StringUtils;

@XmlRootElement
public class FieldSplitRenamer
extends AbstractHeaderRenamer {
    @XmlElement
    private String fieldDelimiter;
    @XmlElement
    private String joinDelimiter;
    @XmlElement
    private Mode mode;
    @XmlElement
    private List<Integer> fields;

    public FieldSplitRenamer() {
        super(HeaderTarget.ALL);
    }

    public FieldSplitRenamer(HeaderTarget target, String fieldDelimiter, String joinDelimiter, Mode mode, List<Integer> fields) {
        super(target);
        this.fieldDelimiter = fieldDelimiter;
        this.joinDelimiter = joinDelimiter;
        this.mode = mode;
        this.fields = fields;
    }

    @Override
    public SequencesGroup rename(SequencesGroup sequences, DatatypeFactory factory) {
        LinkedList<Sequence> renamedSequences = new LinkedList<Sequence>();
        for (int i = 0; i < sequences.getSequenceCount(); ++i) {
            Sequence original = sequences.getSequence(i);
            String partToRename = this.getRenamePart(original);
            String[] parts = partToRename.split(Pattern.quote(this.fieldDelimiter));
            LinkedList<String> newFields = new LinkedList<String>();
            if (this.mode.equals((Object)Mode.REMOVE)) {
                for (int field = 0; field < parts.length; ++field) {
                    if (this.fields.contains(field)) continue;
                    newFields.add(parts[field]);
                }
            } else if (this.mode.equals((Object)Mode.KEEP)) {
                for (int field : this.fields) {
                    if (field >= parts.length) continue;
                    newFields.add(parts[field]);
                }
            } else {
                throw new IllegalStateException("Unknown mode " + (Object)((Object)this.mode));
            }
            String renamedPart = newFields.stream().collect(Collectors.joining(this.joinDelimiter));
            renamedSequences.add(this.renameSequence(original, renamedPart, factory));
        }
        return this.buildSequencesGroup(sequences.getName(), sequences.getProperties(), renamedSequences, factory);
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getJoinDelimiter() {
        return this.joinDelimiter;
    }

    public List<Integer> getFields() {
        return this.fields;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public Validation validate() {
        ArrayList<String> errors = new ArrayList<String>(super.validate().getValidationErrors());
        if (this.fieldDelimiter == null) {
            errors.add("The field delimiter can't be null.");
        }
        if (this.joinDelimiter == null) {
            errors.add("The join delimiter can't be null.");
        }
        if (this.mode == null) {
            errors.add("The mode can't be null.");
        }
        if (this.fields == null) {
            errors.add("The fields list can't be null.");
        } else if (this.fields.isEmpty()) {
            errors.add("The fields list can't be empty.");
        }
        return new DefaultValidation(errors);
    }

    public static enum Mode {
        KEEP,
        REMOVE;


        public String toString() {
            return StringUtils.capitalize(super.toString());
        }
    }
}

