/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.operations;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.operations.SequenceIsoformSelector;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.util.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DefaultSequenceIsoformSelector
implements SequenceIsoformSelector {
    private int referenceSize;
    private TieBreakOption tieBreak;

    public DefaultSequenceIsoformSelector() {
    }

    public DefaultSequenceIsoformSelector(int referenceSize, TieBreakOption tieBreak) {
        this.referenceSize = referenceSize;
        this.tieBreak = tieBreak;
    }

    @Override
    public Sequence selectSequence(List<Sequence> isoforms) {
        Sequence closestToReferenceSize = null;
        int minDistance = Integer.MAX_VALUE;
        for (Sequence s : isoforms) {
            int distance = Math.abs(s.getLength() - this.referenceSize);
            if (distance < minDistance) {
                minDistance = distance;
                closestToReferenceSize = s;
                continue;
            }
            if (distance != minDistance || closestToReferenceSize == null) continue;
            if (this.tieBreak.equals((Object)TieBreakOption.SHORTEST)) {
                if (s.getLength() >= closestToReferenceSize.getLength()) continue;
                closestToReferenceSize = s;
                continue;
            }
            if (s.getLength() <= closestToReferenceSize.getLength()) continue;
            closestToReferenceSize = s;
        }
        return closestToReferenceSize;
    }

    public int getReferenceSize() {
        return this.referenceSize;
    }

    public TieBreakOption getTieBreak() {
        return this.tieBreak;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.referenceSize;
        result = 31 * result + (this.tieBreak == null ? 0 : this.tieBreak.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSequenceIsoformSelector other = (DefaultSequenceIsoformSelector)obj;
        if (this.referenceSize != other.referenceSize) {
            return false;
        }
        return this.tieBreak == other.tieBreak;
    }

    public static enum TieBreakOption {
        SHORTEST,
        LONGEST;


        public String toString() {
            return StringUtils.capitalize(super.toString());
        }
    }
}

