/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.transformation.sequencesgroup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.io.FastaWriter;
import org.sing_group.seda.sapp.datatype.SappCodon;
import org.sing_group.seda.sapp.datatype.SappSpecies;
import org.sing_group.seda.sapp.execution.SappAnnotationPipeline;
import org.sing_group.seda.sapp.execution.SappBinariesExecutor;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class SappAnnotationSequencesGroupTransformation
implements SequencesGroupTransformation {
    public static final SappSpecies DEFAULT_SAPP_SPECIES = SappSpecies.HOMO_SAPIENS;
    public static final SappCodon DEFAULT_CODON = SappCodon.STANDARD;
    private final DatatypeFactory factory;
    private final SappBinariesExecutor sappBinariesExecutor;
    private final BedToolsBinariesExecutor bedToolsBinariesExecutor;
    private final SappSpecies sappSpecies;
    private final SappCodon sappCodon;

    public SappAnnotationSequencesGroupTransformation(SappBinariesExecutor sappBinariesExecutor, BedToolsBinariesExecutor bedToolsBinariesExecutor, SappCodon sappCodon, SappSpecies sappSpecies) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), sappBinariesExecutor, bedToolsBinariesExecutor, sappCodon, sappSpecies);
    }

    public SappAnnotationSequencesGroupTransformation(DatatypeFactory factory, SappBinariesExecutor sappBinariesExecutor, BedToolsBinariesExecutor bedToolsBinariesExecutor, SappCodon sappCodon, SappSpecies sappSpecies) {
        this.sappBinariesExecutor = sappBinariesExecutor;
        this.bedToolsBinariesExecutor = bedToolsBinariesExecutor;
        this.factory = factory;
        this.sappSpecies = sappSpecies;
        this.sappCodon = sappCodon;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        try {
            return this.sappAnnotation(sequencesGroup, this.factory);
        }
        catch (IOException | InterruptedException e) {
            throw new TransformationException("Error while running the SAPP annotation commands." + e.getMessage());
        }
    }

    private SequencesGroup sappAnnotation(SequencesGroup sequencesGroup, DatatypeFactory factory) throws IOException, InterruptedException {
        Path inputFasta = Files.createTempFile(sequencesGroup.getName().replace(" ", ""), "fasta", new FileAttribute[0]);
        FastaWriter.writeFasta(inputFasta, sequencesGroup.getSequences());
        Path outputFasta = Files.createTempFile(sequencesGroup.getName().replace(" ", ""), "_sapp_annotation.fasta", new FileAttribute[0]);
        new SappAnnotationPipeline(factory, this.sappBinariesExecutor, this.bedToolsBinariesExecutor, this.sappCodon, this.sappSpecies).annotate(inputFasta.toFile(), outputFasta.toFile());
        List<Sequence> annotatedSequences = factory.newSequencesGroup(outputFasta).getSequences().collect(Collectors.toList());
        return factory.newSequencesGroup(sequencesGroup.getName(), sequencesGroup.getProperties(), annotatedSequences);
    }
}

