/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.core.execution.AbstractBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.sapp.datatype.SappCodon;
import org.sing_group.seda.sapp.datatype.SappSpecies;
import org.sing_group.seda.sapp.execution.SappBinariesChecker;
import org.sing_group.seda.sapp.execution.SappBinariesExecutor;

public abstract class AbstractSappBinariesExecutor
extends AbstractBinariesExecutor
implements SappBinariesExecutor {
    @Override
    public void checkBinary() throws BinaryCheckException {
        SappBinariesChecker.checkJar(this.getConversionCommand());
        SappBinariesChecker.checkJar(this.getGeneCallerCommand());
    }

    protected abstract String getConversionCommand();

    protected abstract String getGeneCallerCommand();

    protected abstract String toFilePath(File var1);

    public void fasta2hdt(List<String> sappCommand, File input, File output, String sampleIdentifier, SappCodon sappCodon, SappSpecies sappSpecies, String additionalParameters) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(sappCommand);
        parameters.addAll(Arrays.asList("-fasta2hdt", "-input", this.toFilePath(input), "-output", this.toFilePath(output), "-identifier", sampleIdentifier, "-organism", sappSpecies.getSpecies(), "-codon", String.valueOf(sappCodon.getParamValue())));
        if (!additionalParameters.isEmpty()) {
            parameters.addAll(this.getAdditionalParameters(additionalParameters));
        }
        this.executeCommand(parameters);
    }

    public void augustus(List<String> sappCommand, File input, File output, SappCodon sappCodon, SappSpecies sappSpecies) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(sappCommand);
        parameters.addAll(Arrays.asList("-augustus", "-input", this.toFilePath(input), "-output", this.toFilePath(output), "-codon", String.valueOf(sappCodon.getParamValue()), "-species", sappSpecies.getIdentifier()));
        this.executeCommand(parameters, Files.createTempDirectory("augustus-tmp-working-dir", new FileAttribute[0]).toFile());
    }

    private Collection<? extends String> getAdditionalParameters(String additionalParameters) {
        return Arrays.asList(additionalParameters.split(" "));
    }
}

