/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.ss;

import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCategory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCode;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLine;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLineType;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.SourceLine;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.util.EvidenceCodeGenerator;
import uk.ac.ebi.kraken.util.DateUtils;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.impl.ss.SsLineObject;
import uk.ac.ebi.uniprot.parser.impl.ss.UniProtSsLineObject;

public class SsLineConverter
implements Converter<SsLineObject, UniProtSsLineObject> {
    private final DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
    private final DefaultEvidenceFactory evFactory = DefaultEvidenceFactory.getInstance();
    private final EvidenceCodeGenerator evidenceCodeGenerator = new EvidenceCodeGenerator();

    @Override
    public UniProtSsLineObject convert(SsLineObject f) {
        UniProtSsLineObject uniObject = new UniProtSsLineObject();
        for (SsLineObject.EvLine ev : f.ssEVLines) {
            uniObject.evidences.add(this.convert(ev));
        }
        if (f.ssIALines.size() > 0 || f.ssSourceLines.size() > 0) {
            uniObject.internalSection = this.factory.buildInternalSection();
        }
        for (SsLineObject.SsLine ia : f.ssIALines) {
            uniObject.internalSection.getInternalLines().add(this.convert(ia));
        }
        for (String source : f.ssSourceLines) {
            SourceLine sl = this.factory.buildSourceLine();
            sl.setValue(source);
            uniObject.internalSection.getSourceLines().add(sl);
        }
        return uniObject;
    }

    @Override
    private InternalLine convert(SsLineObject.SsLine ia) {
        InternalLine il = this.factory.buildInternalLine();
        il.setInternalLineType(this.convertILType(ia.topic));
        il.setValue(ia.text);
        return il;
    }

    private InternalLineType convertILType(String type) {
        if (type.equals("CL")) {
            return InternalLineType.CL;
        }
        if (type.equals("CP")) {
            return InternalLineType.CP;
        }
        if (type.equals("CX")) {
            return InternalLineType.CX;
        }
        if (type.equals("DG")) {
            return InternalLineType.DG;
        }
        if (type.equals("DR")) {
            return InternalLineType.DR;
        }
        if (type.equals("ET")) {
            return InternalLineType.ET;
        }
        if (type.equals("EV")) {
            return InternalLineType.EV;
        }
        if (type.equals("GO")) {
            return InternalLineType.GO;
        }
        if (type.equals("HA")) {
            return InternalLineType.HA;
        }
        if (type.equals("HP")) {
            return InternalLineType.HP;
        }
        if (type.equals("HR")) {
            return InternalLineType.HR;
        }
        if (type.equals("HU")) {
            return InternalLineType.HU;
        }
        if (type.equals("HW")) {
            return InternalLineType.HW;
        }
        if (type.equals("ID")) {
            return InternalLineType.ID;
        }
        if (type.equals("IS")) {
            return InternalLineType.IS;
        }
        if (type.equals("NI")) {
            return InternalLineType.NI;
        }
        if (type.equals("PE")) {
            return InternalLineType.PE;
        }
        if (type.equals("PM")) {
            return InternalLineType.PM;
        }
        if (type.equals("PROSITE")) {
            return InternalLineType.PROSITE;
        }
        if (type.equals("RU")) {
            return InternalLineType.RU;
        }
        if (type.equals("SO")) {
            return InternalLineType.SO;
        }
        if (type.equals("TX")) {
            return InternalLineType.TX;
        }
        if (type.equals("UP")) {
            return InternalLineType.UP;
        }
        if (type.equals("YY")) {
            return InternalLineType.YY;
        }
        if (type.equals("ZA")) {
            return InternalLineType.ZA;
        }
        if (type.equals("ZB")) {
            return InternalLineType.ZB;
        }
        if (type.equals("ZC")) {
            return InternalLineType.ZC;
        }
        if (type.equals("ZR")) {
            return InternalLineType.ZR;
        }
        if (type.equals("ZZ")) {
            return InternalLineType.ZZ;
        }
        throw new IllegalArgumentException("unknown internal line type " + type);
    }

    @Override
    private Evidence convert(SsLineObject.EvLine e) {
        Evidence ev = this.evFactory.buildEvidence();
        StringBuilder idBuilder = new StringBuilder(e.id);
        if (e.db != null && !e.db.equals("-")) {
            idBuilder.append("|");
            idBuilder.append(e.db);
        }
        if (e.attr1 != null && !e.attr1.isEmpty() && !e.attr1.equals("-")) {
            idBuilder.append(":");
            idBuilder.append(e.attr1);
        }
        ev.setEvidenceId(this.evFactory.buildEvidenceId(idBuilder.toString()));
        ev.setEvidenceCode(EvidenceCode.typeOf(e.id));
        EvidenceType type = this.evidenceCodeGenerator.convertToEvidenceType(ev.getEvidenceCode());
        if (type == EvidenceType.NOT_SPECIFIED) {
            type = EvidenceType.typeOf(e.db);
        }
        ev.setType(type);
        ev.setOriginName(this.evFactory.buildEvidenceOriginName(e.attr2));
        if (ev.getEvidenceId().useECOCode()) {
            ev.setAttribute(this.evFactory.buildEvidenceAttribute(ev.getEvidenceId().getAttribute().getValue()));
        } else {
            ev.setAttribute(this.evFactory.buildEvidenceAttribute(e.attr1));
        }
        ev.setDate(DateUtils.asDate(e.date));
        EvidenceCategory ec = this.evidenceCodeGenerator.convertToEvidenceCategory(ev.getEvidenceCode());
        ev.setCategory(ec);
        return ev;
    }
}

