/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.rc;

import java.util.List;
import uk.ac.ebi.uniprot.parser.ParseTreeObjectExtractor;
import uk.ac.ebi.uniprot.parser.antlr.RcLineParser;
import uk.ac.ebi.uniprot.parser.antlr.RcLineParserBaseListener;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfo;
import uk.ac.ebi.uniprot.parser.impl.rc.RcLineObject;

public class RcLineModelListener
extends RcLineParserBaseListener
implements ParseTreeObjectExtractor<RcLineObject> {
    private RcLineObject object;

    @Override
    public void enterRc_rc(RcLineParser.Rc_rcContext ctx) {
        this.object = new RcLineObject();
    }

    @Override
    public void exitRc(RcLineParser.RcContext ctx) {
        String s;
        RcLineParser.Rc_tokenContext rcTokenContext = ctx.rc_token();
        RcLineObject.RcTokenEnum type = null;
        if (rcTokenContext.PLASMID() != null) {
            type = RcLineObject.RcTokenEnum.PLASMID;
        } else if (rcTokenContext.STRAIN() != null) {
            type = RcLineObject.RcTokenEnum.STRAIN;
        } else if (rcTokenContext.TISSUE() != null) {
            type = RcLineObject.RcTokenEnum.TISSUE;
        } else if (rcTokenContext.TRANSPOSON() != null) {
            type = RcLineObject.RcTokenEnum.TRANSPOSON;
        }
        RcLineObject.RC rc = new RcLineObject.RC();
        rc.tokenType = type;
        List<RcLineParser.Rc_valueContext> rcValueContexts = ctx.rc_text().rc_value();
        for (RcLineParser.Rc_valueContext rcValueContext : rcValueContexts) {
            String text = rcValueContext.rc_value_v().getText();
            rc.values.add(text);
            RcLineParser.EvidenceContext evidence = rcValueContext.evidence();
            if (evidence == null) continue;
            EvidenceInfo.processEvidence(rc.getEvidenceInfo(), text, evidence.EV_TAG());
        }
        int indexOfAnd = -1;
        for (int i = 0; i < rc.values.size(); ++i) {
            s = rc.values.get(i);
            if (!s.startsWith("and ")) continue;
            rc.values.set(i, s.substring(4));
            indexOfAnd = i;
            List<String> strings = rc.getEvidenceInfo().evidences.get(s);
            if (strings == null) break;
            rc.getEvidenceInfo().evidences.put(s.substring(4), strings);
            break;
        }
        if (indexOfAnd > 0 && indexOfAnd < rc.values.size() - 1) {
            int j;
            List<String> evidence = null;
            s = rc.values.get(indexOfAnd);
            for (j = indexOfAnd + 1; j < rc.values.size(); ++j) {
                s = s + ", " + rc.values.get(j);
                evidence = rc.getEvidenceInfo().evidences.remove(rc.values.get(j));
            }
            for (j = indexOfAnd + 1; j < rc.values.size(); ++j) {
                rc.values.remove(j);
            }
            rc.values.set(indexOfAnd, s);
            if (evidence != null) {
                rc.getEvidenceInfo().evidences.put(s, evidence);
            }
        }
        this.object.rcs.add(rc);
    }

    @Override
    public RcLineObject getObject() {
        return this.object;
    }
}

