/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.TerminalNode;

public class EvidenceInfo {
    public Map<Object, List<String>> evidences = new HashMap<Object, List<String>>();
    public static Pattern pattern = Pattern.compile("(-|:)\n[A-Z][A-Z] +");

    public static void processEvidence(EvidenceInfo ev, Object key, List<TerminalNode> terminalNodes) {
        ev.evidences.put(key, EvidenceInfo.processEvidence(terminalNodes));
    }

    public static List<String> processEvidence(List<TerminalNode> terminalNodes) {
        ArrayList<String> strings = new ArrayList<String>();
        for (TerminalNode terminalNode : terminalNodes) {
            String text = terminalNode.getText();
            strings.add(EvidenceInfo.removeHypen(text));
        }
        return strings;
    }

    public static void processEvidenceString(EvidenceInfo ev, Object key, List<String> terminalNodes) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String s : terminalNodes) {
            strings.add(EvidenceInfo.removeHypen(s));
        }
        ev.evidences.put(key, strings);
    }

    public static String removeHypen(String s) {
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            int start = matcher.start() + 1;
            int end = matcher.end();
            String substring1 = s.substring(0, start);
            String substring2 = s.substring(end);
            return substring1 + substring2;
        }
        return s;
    }

    public String retrieveEvidenceString(String nameWithEvidence) {
        String[] strs = EvidenceInfo.splitEvidenceString(nameWithEvidence);
        if (strs.length == 2) {
            this.evidences.put(strs[0], EvidenceInfo.parseEvidenceFromString(strs[1]));
            return strs[0];
        }
        return nameWithEvidence;
    }

    public static String[] splitEvidenceString(String nameWithEvidence) {
        int i;
        if (nameWithEvidence.endsWith("}") && (i = nameWithEvidence.lastIndexOf("{ECO")) >= 0) {
            String name = nameWithEvidence.substring(0, i).trim();
            String evidence = nameWithEvidence.substring(i);
            return new String[]{name, evidence};
        }
        return new String[]{nameWithEvidence};
    }

    public static List<String> parseEvidenceFromString(String evString) {
        assert (evString.startsWith("{") && evString.endsWith("}")) : "not a valid string";
        String substring = evString.substring(1, evString.length() - 1);
        return Arrays.asList(substring.replace(" ", "").split(","));
    }
}

