/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroByteArraySerializer<T> {
    private static final Logger logger = LoggerFactory.getLogger(AvroByteArraySerializer.class);
    private static final int LOG_INTERVAL = 10000;
    private final EncoderFactory encoderFactory;
    private final DecoderFactory decoderFactory;
    private final Class<T> clazz;
    private ThreadLocal<BinaryEncoder> binaryEncoder = new ThreadLocal();
    private ThreadLocal<BinaryDecoder> binaryDecoder = new ThreadLocal();
    private long decodeCount = 0L;
    private long encodeCount = 0L;
    private long jsonEncodeCount = 0L;
    private long decodeTime = 0L;
    private long encodeTime = 0L;
    private long jsonEncodeTime = 0L;

    public static <T> AvroByteArraySerializer<T> instanceOf(Class<T> clazz) {
        return new AvroByteArraySerializer<T>(clazz);
    }

    private AvroByteArraySerializer(Class<T> clazz) {
        this.clazz = clazz;
        this.encoderFactory = EncoderFactory.get();
        this.decoderFactory = DecoderFactory.get();
    }

    public byte[] toByteArray(T entryObject) {
        return this.toByteArray(entryObject, null);
    }

    public byte[] toByteArrayGeneric(GenericRecord entryObject, Schema schema) {
        long l = System.nanoTime();
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        this.binaryEncoder.set(this.encoderFactory.binaryEncoder((OutputStream)byteOutputStream, this.binaryEncoder.get()));
        GenericDatumWriter entryWriter = new GenericDatumWriter(schema);
        if (schema != null) {
            entryWriter.setSchema(schema);
        }
        try {
            this.write((Object)entryObject, l, (DatumWriter)entryWriter, this.binaryEncoder.get());
            return byteOutputStream.toByteArray();
        }
        catch (IOException e) {
            logger.error("Problem during Avro encoding", (Throwable)e);
            return null;
        }
    }

    public String toJson(T entryObject, boolean pretty, Schema schema) {
        long l = System.nanoTime();
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        GenericDatumWriter entryWriter = new GenericDatumWriter();
        if (schema != null) {
            entryWriter.setSchema(schema);
        }
        try {
            JsonEncoder jsonEncoder = this.encoderFactory.jsonEncoder(schema, (OutputStream)byteOutputStream, pretty);
            this.writeJson((Object)entryObject, l, (DatumWriter)entryWriter, jsonEncoder);
            return new String(byteOutputStream.toByteArray());
        }
        catch (IOException e) {
            logger.error("Problem during Avro decoding", (Throwable)e);
            return null;
        }
    }

    private <C> void writeJson(C entryObject, long l, DatumWriter<C> entryWriter, JsonEncoder jsonEncoder) throws IOException {
        try {
            entryWriter.write(entryObject, (Encoder)jsonEncoder);
            jsonEncoder.flush();
            ++this.jsonEncodeCount;
            this.jsonEncodeTime += System.nanoTime() - l;
            this.logProgress("Avro encoded {} JSON objects in {} seconds", this.jsonEncodeCount, this.jsonEncodeTime);
        }
        catch (IOException e) {
            logger.error("Problem during Avro JSON encoding", (Throwable)e);
        }
    }

    private <D> void write(D entryObject, long l, DatumWriter<D> entryWriter, BinaryEncoder encoder) throws IOException {
        try {
            entryWriter.write(entryObject, (Encoder)encoder);
            this.binaryEncoder.get().flush();
            ++this.encodeCount;
            this.encodeTime += System.nanoTime() - l;
            this.logProgress("Avro encoded {} objects in {} seconds", this.encodeCount, this.encodeTime);
        }
        catch (IOException e) {
            logger.error("Problem during Avro encoding", (Throwable)e);
        }
    }

    public byte[] toByteArray(T entryObject, Schema schema) {
        long l = System.nanoTime();
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        this.binaryEncoder.set(this.encoderFactory.binaryEncoder((OutputStream)byteOutputStream, this.binaryEncoder.get()));
        SpecificDatumWriter entryWriter = new SpecificDatumWriter(this.clazz);
        if (schema != null) {
            entryWriter.setSchema(schema);
        }
        try {
            this.write((Object)entryObject, l, (DatumWriter)entryWriter, this.binaryEncoder.get());
            return byteOutputStream.toByteArray();
        }
        catch (IOException e) {
            logger.error("Problem during Avro encoding", (Throwable)e);
            return null;
        }
    }

    public T fromByteArray(byte[] bytes) {
        return this.fromByteArray(bytes, null);
    }

    public GenericRecord fromByteArrayGeneric(byte[] bytes, Schema schema) {
        long l = System.nanoTime();
        SpecificDatumReader entryReader = new SpecificDatumReader(schema);
        if (schema != null) {
            entryReader.setSchema(schema);
        }
        this.binaryDecoder.set(this.decoderFactory.binaryDecoder(bytes, this.binaryDecoder.get()));
        return (GenericRecord)this.read(l, (DatumReader)entryReader, this.binaryDecoder.get());
    }

    private <D> D read(long l, DatumReader<D> entryReader, BinaryDecoder decoder) {
        try {
            Object readEntry = entryReader.read(null, (Decoder)decoder);
            ++this.decodeCount;
            this.decodeTime += System.nanoTime() - l;
            this.logProgress("Avro decoded {} objects in {} seconds", this.decodeCount, this.decodeTime);
            return (D)readEntry;
        }
        catch (IOException e) {
            logger.error("Problem during Avro decoding", (Throwable)e);
            return null;
        }
    }

    public T fromByteArray(byte[] bytes, Schema schema) {
        long l = System.nanoTime();
        SpecificDatumReader entryReader = new SpecificDatumReader(this.clazz);
        if (schema != null) {
            entryReader.setSchema(schema);
        }
        this.binaryDecoder.set(this.decoderFactory.binaryDecoder(bytes, this.binaryDecoder.get()));
        return (T)this.read(l, (DatumReader)entryReader, this.binaryDecoder.get());
    }

    private void logProgress(String messageFormat, long unitCount, long nanoTime) {
        if (unitCount % 10000L == 0L) {
            logger.debug(messageFormat, (Object)unitCount, (Object)TimeUnit.NANOSECONDS.toSeconds(nanoTime));
        }
    }
}

