/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.ref;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSource;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.RefCommentTypeConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.RefComment;

public class RefCommentConverter
implements Converter<SampleSource, RefComment> {
    private final DefaultCitationNewFactory factory = DefaultCitationNewFactory.getInstance();
    private static final EvidenceConverter evidenceConverter = new EvidenceConverter();
    private final RefCommentTypeConverter typeConverter = new RefCommentTypeConverter();

    @Override
    public RefComment toAvro(SampleSource u) {
        RefComment.Builder builder = RefComment.newBuilder();
        builder.setComment(ConverterHelper.convert(u.getValue(), u.getEvidenceIds()));
        builder.setType(this.typeConverter.toAvro(u.getType()));
        return builder.build();
    }

    @Override
    public SampleSource fromAvro(RefComment a) {
        SampleSource ss = this.factory.buildSampleSource(this.typeConverter.fromAvro(a.getType()));
        ss.setValue(a.getComment().getKey().toString());
        ss.setEvidenceIds(evidenceConverter.fromAvro(a.getComment().getEvidence()));
        return ss;
    }
}

