/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.feature;

import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.PolyphenPredictionType;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.SiftPredictionType;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.VariantType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.feature.VariantAssociationConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.feature.AvroVariant;
import uk.ac.ebi.uniprot.services.data.serializer.model.feature.AvroVariantPrediction;

public class VariantConverter
implements Converter<VariantType, AvroVariant> {
    private final VariantAssociationConverter associationConverter = new VariantAssociationConverter();

    @Override
    public AvroVariant toAvro(VariantType varType) {
        AvroVariant.Builder builder = AvroVariant.newBuilder();
        builder.setSomaticStatus(varType.isSomaticStatus());
        if (varType.getClinicalSignificance() != null) {
            builder.setClinicalSignificance(varType.getClinicalSignificance());
        }
        if (varType.getConsequenceType() != null) {
            builder.setConsequenceType(varType.getConsequenceType());
        }
        if (varType.getCytogeneticBand() != null) {
            builder.setCytogeneticBand(varType.getCytogeneticBand());
        }
        if (varType.getFrequency() != null) {
            builder.setFrequency(varType.getFrequency());
        }
        if (varType.getGenomicLocation() != null) {
            builder.setGenomicLocation(varType.getGenomicLocation());
        }
        if (varType.getMutatedType() != null) {
            builder.setMutatedType(varType.getMutatedType());
        }
        if (varType.getPolyphenPrediction() != null) {
            builder.setPolyphenPrediction(this.convertPolyphenPredictionType(varType.getPolyphenPrediction()));
        }
        if (varType.getSiftPrediction() != null) {
            builder.setSiftPrediction(this.convertSiftPredictionType(varType.getSiftPrediction()));
        }
        if (varType.getSourceType() != null) {
            builder.setSourceType(varType.getSourceType());
        }
        if (varType.getWildType() != null) {
            builder.setWildType(varType.getWildType());
        }
        builder.setAssociations(varType.getAssociation().stream().map(this.associationConverter::toAvro).collect(Collectors.toList()));
        return builder.build();
    }

    private AvroVariantPrediction convertPolyphenPredictionType(PolyphenPredictionType predType) {
        AvroVariantPrediction.Builder builder = AvroVariantPrediction.newBuilder();
        if (predType.getPredication() != null) {
            builder.setPredication(predType.getPredication());
        }
        if (predType.getValue() != null) {
            builder.setValue(predType.getValue());
        }
        if (predType.getScore() != null) {
            builder.setScore(predType.getScore());
        }
        return builder.build();
    }

    private AvroVariantPrediction convertSiftPredictionType(SiftPredictionType siftType) {
        AvroVariantPrediction.Builder builder = AvroVariantPrediction.newBuilder();
        if (siftType.getPredication() != null) {
            builder.setPredication(siftType.getPredication());
        }
        if (siftType.getValue() != null) {
            builder.setValue(siftType.getValue());
        }
        if (siftType.getScore() != null) {
            builder.setScore(siftType.getScore());
        }
        return builder.build();
    }

    @Override
    public VariantType fromAvro(AvroVariant avro) {
        VariantType variant = new VariantType();
        variant.setSomaticStatus(avro.getSomaticStatus());
        if (avro.getClinicalSignificance() != null) {
            variant.setClinicalSignificance(avro.getClinicalSignificance().toString());
        }
        if (avro.getConsequenceType() != null) {
            variant.setConsequenceType(avro.getConsequenceType().toString());
        }
        if (avro.getCytogeneticBand() != null) {
            variant.setCytogeneticBand(avro.getCytogeneticBand().toString());
        }
        if (avro.getFrequency() != null) {
            variant.setFrequency(avro.getFrequency());
        }
        if (avro.getGenomicLocation() != null) {
            variant.setGenomicLocation(avro.getGenomicLocation().toString());
        }
        if (avro.getMutatedType() != null) {
            variant.setMutatedType(avro.getMutatedType().toString());
        }
        if (avro.getPolyphenPrediction() != null) {
            variant.setPolyphenPrediction(this.convertToPolyphenPredictionType(avro.getPolyphenPrediction()));
        }
        if (avro.getSiftPrediction() != null) {
            variant.setSiftPrediction(this.convertToSiftPredictionType(avro.getSiftPrediction()));
        }
        if (avro.getSourceType() != null) {
            variant.setSourceType(avro.getSourceType().toString());
        }
        if (avro.getWildType() != null) {
            variant.setWildType(avro.getWildType().toString());
        }
        avro.getAssociations().stream().map(this.associationConverter::fromAvro).forEach(variant.getAssociation()::add);
        return variant;
    }

    private PolyphenPredictionType convertToPolyphenPredictionType(AvroVariantPrediction avro) {
        PolyphenPredictionType predType = new PolyphenPredictionType();
        if (avro.getPredication() != null) {
            predType.setPredication(avro.getPredication().toString());
        }
        if (avro.getValue() != null) {
            predType.setValue(avro.getValue().toString());
        }
        if (avro.getScore() != null) {
            predType.setScore(avro.getScore());
        }
        return predType;
    }

    private SiftPredictionType convertToSiftPredictionType(AvroVariantPrediction avro) {
        SiftPredictionType predType = new SiftPredictionType();
        if (avro.getPredication() != null) {
            predType.setPredication(avro.getPredication().toString());
        }
        if (avro.getValue() != null) {
            predType.setValue(avro.getValue().toString());
        }
        if (avro.getScore() != null) {
            predType.setScore(avro.getScore());
        }
        return predType;
    }
}

