/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.feature;

import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.DbReferenceType;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.EvidenceType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.feature.AvroEvidence;

public class EvidenceConverter
implements Converter<EvidenceType, AvroEvidence> {
    @Override
    public AvroEvidence toAvro(EvidenceType evType) {
        AvroEvidence.Builder builder = AvroEvidence.newBuilder();
        if (evType.getCode() != null) {
            builder.setEco(evType.getCode());
        }
        if (evType.getDbReference() != null) {
            builder.setDbId(evType.getDbReference().getId());
            builder.setDatabase(evType.getDbReference().getType());
        }
        return builder.build();
    }

    @Override
    public EvidenceType fromAvro(AvroEvidence avro) {
        EvidenceType evType = new EvidenceType();
        if (avro.getEco() != null) {
            evType.setCode(avro.getEco().toString());
        }
        if (avro.getDatabase() != null) {
            DbReferenceType dbRefType = new DbReferenceType();
            dbRefType.setType(avro.getDatabase().toString());
            dbRefType.setId(avro.getDbId().toString());
            evType.setDbReference(dbRefType);
        }
        return evType;
    }
}

