/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.SequenceCaution;

public class SequenceCautionCommentConverter
extends AbstractCommentConverter<SequenceCautionComment> {
    @Override
    protected Object convertToAvro(SequenceCautionComment u) {
        SequenceCaution.Builder builder = SequenceCaution.newBuilder();
        if (!Strings.isNullOrEmpty((String)u.getMolecule())) {
            builder.setMolecule(u.getMolecule());
        }
        builder.setEvidence(evidenceConverter.toAvro(u.getEvidenceIds()));
        builder.setNote(u.getNote().getValue());
        builder.setConflictType(u.getType().toDisplayName());
        builder.setSequence(u.getSequence());
        return builder.build();
    }

    @Override
    protected SequenceCautionComment convertFromAvro(CommentType type, Object avroObj) {
        SequenceCautionComment comment = (SequenceCautionComment)factory.buildComment(type);
        SequenceCaution sc = (SequenceCaution)((Object)avroObj);
        if (sc.getMolecule() != null) {
            comment.setMolecule(sc.getMolecule().toString());
        }
        comment.setEvidenceIds(evidenceConverter.fromAvro(sc.getEvidence()));
        comment.setType(SequenceCautionType.typeOf(sc.getConflictType().toString()));
        comment.setNote(factory.buildSequenceCautionCommentNote(sc.getNote().toString()));
        comment.setSequence(sc.getSequence().toString());
        return comment;
    }
}

