/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.ReactionReferenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.AvroReaction;

public class ReactionConverter
implements Converter<Reaction, AvroReaction> {
    private final CommentFactory factory = DefaultCommentFactory.getInstance();
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();
    private final ReactionReferenceConverter referenceConverter = new ReactionReferenceConverter();

    @Override
    public AvroReaction toAvro(Reaction u) {
        AvroReaction.Builder builder = AvroReaction.newBuilder();
        builder.setEc(u.getECNumber()).setName(u.getName()).setReactionReferences(u.getReactionReferences().stream().map(this.referenceConverter::toAvro).collect(Collectors.toList())).setEvidences(this.evidenceConverter.toAvro(u.getEvidenceIds()));
        return builder.build();
    }

    @Override
    public Reaction fromAvro(AvroReaction a) {
        Reaction reaction = this.factory.buildReaction();
        if (a.getEc() != null) {
            reaction.setECNumber(a.getEc().toString());
        }
        if (a.getName() != null) {
            reaction.setName(a.getName().toString());
        }
        reaction.setEvidenceIds(this.evidenceConverter.fromAvro(a.getEvidences()));
        reaction.setReactionReferences(a.getReactionReferences().stream().map(this.referenceConverter::fromAvro).collect(Collectors.toList()));
        return reaction;
    }
}

