/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class RNAPositionConverter
implements Converter<Position, EvidencedString> {
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();

    @Override
    public EvidencedString toAvro(Position p) {
        return ConverterHelper.convert(p.getPosition(), p.getEvidenceIds());
    }

    @Override
    public Position fromAvro(EvidencedString es) {
        Position position = DefaultCommentFactory.getInstance().buildRnaEditingPosition();
        position.setPosition(es.getKey().toString());
        position.setEvidenceIds(this.evidenceConverter.fromAvro(es.getEvidence()));
        return position;
    }
}

