/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingLocationType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.RNAPositionConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.RNAEditing;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class RNAEditingCommentConverter
extends AbstractCommentConverter<RnaEditingComment> {
    private final RNAPositionConverter positionConverter = new RNAPositionConverter();

    @Override
    protected Object convertToAvro(RnaEditingComment u) {
        RNAEditing.Builder builder = RNAEditing.newBuilder();
        if (!Strings.isNullOrEmpty((String)u.getMolecule())) {
            builder.setMolecule(u.getMolecule());
        }
        if (u.getRnaEditingNote() != null && u.getRnaEditingNote().getTexts() != null) {
            builder.setNote(u.getRnaEditingNote().getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        builder.setLocationType(ConverterHelper.convert(u.getLocationType().name(), u.getEvidenceIds()));
        if (!u.getPositionsWithEvidences().isEmpty()) {
            builder.setLocations(u.getPositionsWithEvidences().stream().map(val -> this.positionConverter.toAvro((Position)val)).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Override
    protected RnaEditingComment convertFromAvro(CommentType type, Object avroObj) {
        RnaEditingComment comment = (RnaEditingComment)factory.buildComment(type);
        RNAEditing editing = (RNAEditing)((Object)avroObj);
        if (editing.getMolecule() != null) {
            comment.setMolecule(editing.getMolecule().toString());
        }
        if (editing.getNote() != null) {
            RnaEditingNote note = factory.buildRnaEditingNote();
            List<EvidencedValue> evValues = editing.getNote().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList());
            note.setTexts(evValues);
            comment.setRnaEditingNote(note);
        }
        if (editing.getLocations() != null && !editing.getLocations().isEmpty()) {
            comment.setPositions(editing.getLocations().stream().map(val -> this.positionConverter.fromAvro((EvidencedString)((Object)val))).collect(Collectors.toList()));
        }
        comment.setLocationType(RnaEditingLocationType.valueOf(editing.getLocationType().getKey().toString()));
        comment.setEvidenceIds(evidenceConverter.fromAvro(editing.getLocationType().getEvidence()));
        return comment;
    }
}

