/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.og.OrganismName;
import uk.ac.ebi.uniprot.services.data.serializer.model.og.OrganismNameType;

public class OrganismNameConverter
implements Converter<Organism, List<OrganismName>> {
    private static DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();

    @Override
    public List<OrganismName> toAvro(Organism u) {
        ArrayList<OrganismName> orNames = new ArrayList<OrganismName>();
        orNames.add(this.buildName(OrganismNameType.SCIENTIFIC, u.getScientificName().getValue()));
        if (u.hasCommonName()) {
            orNames.add(this.buildName(OrganismNameType.COMMON, u.getCommonName().getValue()));
        }
        if (u.hasSynonym()) {
            orNames.add(this.buildName(OrganismNameType.SYNONYM, u.getSynonym().getValue()));
        }
        return orNames;
    }

    private OrganismName buildName(OrganismNameType type, String value) {
        OrganismName.Builder sbuilder = OrganismName.newBuilder();
        sbuilder.setType(type);
        sbuilder.setName(value);
        return sbuilder.build();
    }

    @Override
    public Organism fromAvro(List<OrganismName> a) {
        Organism organism = factory.buildOrganism();
        for (OrganismName ogName : a) {
            if (ogName.getType() == OrganismNameType.SCIENTIFIC) {
                organism.setScientificName(factory.buildOrganismScientificName(ogName.getName().toString()));
                continue;
            }
            if (ogName.getType() == OrganismNameType.COMMON) {
                organism.setCommonName(factory.buildOrganismCommonName(ogName.getName().toString()));
                continue;
            }
            if (ogName.getType() != OrganismNameType.SYNONYM) continue;
            organism.setSynonym(factory.buildOrganismSynonym(ogName.getName().toString()));
        }
        return organism;
    }
}

