/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.og.Organelle;
import uk.ac.ebi.uniprot.services.data.serializer.model.og.OrganelleType;

public class OrganelleConverter
implements Converter<Organelle, uk.ac.ebi.uniprot.services.data.serializer.model.og.Organelle> {
    private static DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
    private static EvidenceConverter evidenceConverter = new EvidenceConverter();
    private final OrganelleTypeConverter typeConverter = new OrganelleTypeConverter();

    @Override
    public uk.ac.ebi.uniprot.services.data.serializer.model.og.Organelle toAvro(Organelle organelle) {
        Organelle.Builder builder = uk.ac.ebi.uniprot.services.data.serializer.model.og.Organelle.newBuilder();
        OrganelleType type = this.typeConverter.toAvro(organelle.getType());
        builder.setType(type);
        if (type == OrganelleType.PLASMID) {
            builder.setValue(organelle.getValue());
        }
        builder.setEvidence(evidenceConverter.toAvro(organelle.getEvidenceIds()));
        return builder.build();
    }

    @Override
    public Organelle fromAvro(uk.ac.ebi.uniprot.services.data.serializer.model.og.Organelle avroOrganelle) {
        Organelle organelle = factory.buildOrganelle(this.typeConverter.fromAvro(avroOrganelle.getType()));
        organelle.setEvidenceIds(evidenceConverter.fromAvro(avroOrganelle.getEvidence()));
        if (avroOrganelle.getType() == OrganelleType.PLASMID) {
            organelle.setValue(avroOrganelle.getValue().toString());
        }
        return organelle;
    }

    public static class OrganelleTypeConverter
    implements Converter<GeneEncodingType, OrganelleType> {
        @Override
        public OrganelleType toAvro(GeneEncodingType type) {
            return OrganelleType.valueOf(type.name());
        }

        @Override
        public GeneEncodingType fromAvro(OrganelleType avroType) {
            return GeneEncodingType.valueOf(avroType.name());
        }
    }
}

