/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.DescriptionNameConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.de.Name;
import uk.ac.ebi.uniprot.services.data.serializer.model.de.ProteinName;

public class DescriptionSectionConverter
implements Converter<Section, ProteinName> {
    private static DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
    private final DescriptionNameConverter nameConverter = new DescriptionNameConverter();

    @Override
    public ProteinName toAvro(Section section) {
        ProteinName.Builder ProteinNameBuilder = ProteinName.newBuilder();
        List<uk.ac.ebi.kraken.interfaces.uniprot.description.Name> recNames = section.getNamesByType(NameType.RECNAME);
        if (!recNames.isEmpty()) {
            ProteinNameBuilder.setRecommendedName(this.nameConverter.toAvro(recNames.get(0)));
        }
        ProteinNameBuilder.setAlternativeName(section.getNamesByType(NameType.ALTNAME).stream().map(name -> this.nameConverter.toAvro((uk.ac.ebi.kraken.interfaces.uniprot.description.Name)name)).collect(Collectors.toList()));
        ProteinNameBuilder.setSubmittedName(section.getNamesByType(NameType.SUBNAME).stream().map(name -> this.nameConverter.toAvro((uk.ac.ebi.kraken.interfaces.uniprot.description.Name)name)).collect(Collectors.toList()));
        return ProteinNameBuilder.build();
    }

    @Override
    public Section fromAvro(ProteinName avroProteinName) {
        Section section = factory.buildSection();
        ArrayList<uk.ac.ebi.kraken.interfaces.uniprot.description.Name> names = new ArrayList<uk.ac.ebi.kraken.interfaces.uniprot.description.Name>();
        if (avroProteinName.getRecommendedName() != null) {
            names.add(this.convertFromAvroName(NameType.RECNAME, avroProteinName.getRecommendedName()));
        }
        names.addAll(avroProteinName.getAlternativeName().stream().map(aName -> this.convertFromAvroName(NameType.ALTNAME, (Name)((Object)aName))).collect(Collectors.toList()));
        names.addAll(avroProteinName.getSubmittedName().stream().map(aName -> this.convertFromAvroName(NameType.SUBNAME, (Name)((Object)aName))).collect(Collectors.toList()));
        section.setNames(names);
        return section;
    }

    private uk.ac.ebi.kraken.interfaces.uniprot.description.Name convertFromAvroName(NameType nameType, Name aName) {
        uk.ac.ebi.kraken.interfaces.uniprot.description.Name name = this.nameConverter.fromAvro(aName);
        name.setNameType(nameType);
        return name;
    }
}

