/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.query.impl;

import java.util.Arrays;

class AbstractQueryBase {
    public static char[] escaping_char = new char[]{'+', '-', '&', '|', '!', '(', ')', '{', '}', '[', ']', '^', '\"', '~', '*', '?', ':', '/'};
    String initField;
    String initValue;
    boolean negative;
    String quoteStart;
    String quoteEnd;

    private AbstractQueryBase() {
    }

    AbstractQueryBase(String initField, String initValue, boolean negative, String start, String end) {
        this.initField = initField;
        this.initValue = initValue;
        this.negative = negative;
        this.quoteStart = start;
        this.quoteEnd = end;
    }

    String getInitField() {
        return this.initField;
    }

    void setInitField(String initField) {
        this.initField = initField;
    }

    String getInitValue() {
        return this.initValue;
    }

    void setInitValue(String initValue) {
        this.initValue = initValue;
    }

    boolean isNegative() {
        return this.negative;
    }

    void setNegative(boolean negative) {
        this.negative = negative;
    }

    public String escapingString(String input) {
        if (input.equals("*")) {
            return input;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char cc = input.charAt(i);
            if (this.needEscape(cc)) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(cc);
        }
        return stringBuilder.toString();
    }

    public boolean needEscape(char c) {
        int i = Arrays.binarySearch(escaping_char, c);
        return i >= 0;
    }

    public String getQueryString() {
        return this.getQueryString(0);
    }

    public String getQueryString(int slop) {
        StringBuilder sb = new StringBuilder();
        if (this.negative) {
            sb.append("!(");
        } else {
            sb.append("(");
        }
        sb.append(this.initField).append(" : ");
        boolean hasSpace = this.initValue.contains(" ");
        String phaseQuoteStart = hasSpace ? this.quoteStart : "";
        String phaseQuoteEnd = hasSpace ? this.quoteEnd : "";
        sb.append(phaseQuoteStart).append(this.escapingString(this.initValue)).append(phaseQuoteEnd);
        if (slop > 0) {
            sb.append("~").append(slop);
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.initField == null ? 0 : this.initField.hashCode());
        result = 31 * result + (this.initValue == null ? 0 : this.initValue.hashCode());
        result = 31 * result + (this.negative ? 1231 : 1237);
        result = 31 * result + (this.quoteEnd == null ? 0 : this.quoteEnd.hashCode());
        result = 31 * result + (this.quoteStart == null ? 0 : this.quoteStart.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQueryBase other = (AbstractQueryBase)obj;
        if (this.initField == null ? other.initField != null : !this.initField.equals(other.initField)) {
            return false;
        }
        if (this.initValue == null ? other.initValue != null : !this.initValue.equals(other.initValue)) {
            return false;
        }
        if (this.negative != other.negative) {
            return false;
        }
        if (this.quoteEnd == null ? other.quoteEnd != null : !this.quoteEnd.equals(other.quoteEnd)) {
            return false;
        }
        return !(this.quoteStart == null ? other.quoteStart != null : !this.quoteStart.equals(other.quoteStart));
    }

    public String toString() {
        return "AbstractQueryBase [initField=" + this.initField + ", initValue=" + this.initValue + ", negative=" + this.negative + ", quoteStart=" + this.quoteStart + ", quoteEnd=" + this.quoteEnd + "]";
    }

    static {
        Arrays.sort(escaping_char);
    }
}

