/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniref.impl;

import java.util.Collections;
import uk.ac.ebi.kraken.interfaces.factories.UniRefFactory;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntryName;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefRepresentativeMember;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniref.impl.UniRefComponentImpl;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.uniref.UniRefConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniref.AvroUniRef;

class JapiUniRefResponseAdapter {
    static final UniRefEntryNameResponseAdaptor unirefEntryName = new UniRefEntryNameResponseAdaptor();
    static final UniRefRepresentativeResponseAdaptor unirefRepresentative = new UniRefRepresentativeResponseAdaptor();
    static final JapiUniParcEntryAdapter unirefEntry = new JapiUniParcEntryAdapter();
    private static final UniRefFactory FACTORY = DefaultUniRefFactory.getInstance();
    private static final UniRefConverter converter = new UniRefConverter();

    JapiUniRefResponseAdapter() {
    }

    static class UniRefRepresentativeResponseAdaptor
    implements ResponseAdaptor<UniRefComponent<UniRefRepresentativeMember>, AvroUniRef> {
        UniRefRepresentativeResponseAdaptor() {
        }

        @Override
        public UniRefComponent<UniRefRepresentativeMember> adapt(AvroUniRef avroEntry) {
            UniRefEntry entry = converter.fromAvro(avroEntry);
            return UniRefComponentImpl.getInstance(entry.getUniRefEntryId().getValue(), Collections.singletonList(entry.getRepresentativeMember()));
        }
    }

    static class UniRefEntryNameResponseAdaptor
    implements ResponseAdaptor<UniRefComponent<UniRefEntryName>, AvroUniRef> {
        UniRefEntryNameResponseAdaptor() {
        }

        @Override
        public UniRefComponent<UniRefEntryName> adapt(AvroUniRef avroEntry) {
            UniRefEntry entry = converter.fromAvro(avroEntry);
            return UniRefComponentImpl.getInstance(entry.getUniRefEntryId().getValue(), Collections.singletonList(FACTORY.buildUniRefEntryName(entry.getName().getValue())));
        }
    }

    static class JapiUniParcEntryAdapter
    implements ResponseAdaptor<UniRefEntry, AvroUniRef> {
        JapiUniParcEntryAdapter() {
        }

        @Override
        public UniRefEntry adapt(AvroUniRef avroEntry) {
            UniRefEntry entry = converter.fromAvro(avroEntry);
            String uniRefEntryId = entry.getUniRefEntryId().getValue();
            for (UniRefDatabaseType databaseType : UniRefDatabaseType.values()) {
                if (!uniRefEntryId.startsWith(databaseType.toString())) continue;
                entry.getUniRefDatabase().setType(databaseType);
                break;
            }
            return entry;
        }
    }
}

