/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniref;

import com.google.common.base.Strings;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.util.AccessionResolver;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefField;
import uk.ac.ebi.uniprot.dataservice.query.Query;
import uk.ac.ebi.uniprot.dataservice.query.QueryFactory;
import uk.ac.ebi.uniprot.dataservice.query.impl.Accessor;

public class UniRefQueryBuilder {
    public static QueryFactory factory() {
        return Accessor.getDefault().getQueryFactoryInstance();
    }

    public static Query uniRefClusterDatabase(UniRefDatabaseType clusterDbType) {
        return UniRefQueryBuilder.query(UniRefField.Search.database, clusterDbType.name());
    }

    public static Query clusterId(String uniRefId) {
        if (Strings.isNullOrEmpty((String)uniRefId)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        if (!AccessionResolver.isUnirefAccession(uniRefId)) {
            return UniRefQueryBuilder.factory().createEmptyQuery();
        }
        int indexUnderScore = uniRefId.indexOf(95);
        String formattedUniRefId = String.format("UniRef%s_%s", uniRefId.substring(6, indexUnderScore), uniRefId.substring(indexUnderScore + 1).toUpperCase());
        return UniRefQueryBuilder.query(UniRefField.Search.cluster_id, formattedUniRefId);
    }

    public static Query clusterName(String clusterName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniRefQueryBuilder.query(UniRefField.Search.cluster_name, clusterName);
    }

    public static Query representativeId(String id) {
        if (!AccessionResolver.isUniprotID(id) && !AccessionResolver.isUniparcAccession(id)) {
            return UniRefQueryBuilder.factory().createEmptyQuery();
        }
        return UniRefQueryBuilder.query(UniRefField.Search.rep_member_id, id);
    }

    public static Query representativeAccession(String accession) {
        if (!AccessionResolver.isUniprotAccession(accession) && !AccessionResolver.isUniparcAccession(accession)) {
            return UniRefQueryBuilder.factory().createEmptyQuery();
        }
        Query accessionQuery = UniRefQueryBuilder.query(UniRefField.Search.rep_member_entry_id, accession);
        Query onlyUniParcInEntryQuery = UniRefQueryBuilder.accessionQueryForOnlyUniParcInMember(accession, UniRefField.Search.rep_member_id);
        return UniRefQueryBuilder.or(onlyUniParcInEntryQuery, accessionQuery);
    }

    public static Query representativeProteinName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniRefQueryBuilder.query(UniRefField.Search.rep_member_protein_name, name);
    }

    public static Query representativeOrganismName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniRefQueryBuilder.query(UniRefField.Search.rep_member_organism_name, name);
    }

    public static Query representativeTaxonId(int taxId) {
        return UniRefQueryBuilder.query(UniRefField.Search.rep_member_tax_id, String.valueOf(taxId));
    }

    private static Query accessionQueryForOnlyUniParcInMember(String accession, UniRefField.Search searchField) {
        return UniRefQueryBuilder.query(searchField, accession);
    }

    public static Query memberId(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniRefQueryBuilder.query(UniRefField.Search.member_id, id);
    }

    public static Query memberAccession(String accession) {
        Query accessionQuery = UniRefQueryBuilder.query(UniRefField.Search.member_entry_id, accession);
        Query onlyUniParcInEntryQuery = UniRefQueryBuilder.accessionQueryForOnlyUniParcInMember(accession, UniRefField.Search.member_id);
        return UniRefQueryBuilder.or(onlyUniParcInEntryQuery, accessionQuery);
    }

    public static Query memberProteinName(String name) {
        return UniRefQueryBuilder.query(UniRefField.Search.member_protein_name, name);
    }

    public static Query memberOrganismName(String name) {
        return UniRefQueryBuilder.query(UniRefField.Search.member_organism_name, name);
    }

    public static Query memberTaxonId(int taxId) {
        return UniRefQueryBuilder.query(UniRefField.Search.member_tax_id, String.valueOf(taxId));
    }

    public static Query query(UniRefField.Search field, String value) {
        return UniRefQueryBuilder.factory().createPhraseQuery(field.name(), value, false);
    }

    public static Query and(Query ... subQueries) {
        return UniRefQueryBuilder.factory().and(subQueries);
    }

    public static Query or(Query ... subQueries) {
        return UniRefQueryBuilder.factory().or(subQueries);
    }

    public static Query not(UniRefField.Search field, String value) {
        return UniRefQueryBuilder.factory().createPhraseQuery(field.name(), value, true);
    }
}

