/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckStatus {
    private final String message = "";
    private final List<CheckStatus> childStatus = new ArrayList<CheckStatus>();
    private final Exception exception;

    private CheckStatus(Exception exception) {
        this.exception = exception;
    }

    private CheckStatus(Collection<CheckStatus> checkStatuses) {
        this.exception = null;
        this.childStatus.addAll(checkStatuses);
    }

    public boolean isSuccess() {
        if (this.childStatus.isEmpty()) {
            return this.exception == null;
        }
        return this.childStatus.stream().allMatch(s -> s.isSuccess());
    }

    public static CheckStatus failed(Exception e) {
        return new CheckStatus(e);
    }

    public static CheckStatus success() {
        return new CheckStatus((Exception)null);
    }

    public static CheckStatus result(Collection<CheckStatus> collect) {
        return new CheckStatus(collect);
    }
}

