/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.basic.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.Request;
import uk.ac.ebi.uniprot.dataservice.client.RequestSerializer;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.basic.impl.JapiResponseImpl;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.EmptyResponse;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;

public final class JapiBasicService<T>
implements BasicService<Response<T>> {
    private static final String X_PAGINATION_TOTALRECORDS = "x-pagination-totalrecords";
    private final String serverURL;
    private final HttpRequestConfig httpRequestConfig;
    private CloseableHttpClient httpClient;
    private Service serviceDelegate;
    private Class<T> avroEntityClass;
    private static final Logger logger = LoggerFactory.getLogger(JapiBasicService.class);

    public JapiBasicService(String serverURL, HttpRequestConfig serverConfig, Class<T> avroEntityClass) {
        this.serverURL = serverURL;
        this.httpRequestConfig = serverConfig;
        this.serviceDelegate = new ServiceDelegate();
        this.avroEntityClass = avroEntityClass;
    }

    @Override
    public synchronized void start() {
        Service.State state = this.serviceDelegate.state();
        if (state == Service.State.RUNNING || state == Service.State.STARTING) {
            logger.debug("Service is already Running: " + this.getClass().getSimpleName());
            return;
        }
        if (state == Service.State.TERMINATED || state == Service.State.FAILED) {
            this.serviceDelegate = new ServiceDelegate();
            logger.debug("Service is stopped, will now be restarted: " + this.getClass().getSimpleName());
        }
        logger.debug("Starting service: " + this.getClass().getSimpleName());
        this.serviceDelegate.startAsync();
        this.serviceDelegate.awaitRunning();
        logger.debug("Service started: " + this.getClass().getSimpleName());
        Preconditions.checkNotNull((Object)this.httpClient, (Object)"HTTP Connection Service doesn't after service being started. please Report the issue!");
    }

    @Override
    public synchronized void stop() {
        Service.State serviceState = this.serviceDelegate.state();
        if (serviceState == Service.State.STOPPING || serviceState == Service.State.FAILED || serviceState == Service.State.TERMINATED) {
            logger.debug("Service is already Stopped: " + this.getClass().getSimpleName());
            return;
        }
        logger.debug("Stopping service: " + this.getClass().getSimpleName());
        this.serviceDelegate.stopAsync();
        this.serviceDelegate.awaitTerminated();
        logger.debug("Service stopped: " + this.getClass().getSimpleName());
    }

    @Override
    public boolean isStarted() {
        return this.serviceDelegate.isRunning();
    }

    @Override
    public Response<T> execute(Request query) throws ServiceException {
        Preconditions.checkState((boolean)this.serviceDelegate.isRunning(), (Object)"Service is not running, please start it before doing anything else.");
        Preconditions.checkNotNull((Object)this.httpClient, (Object)"http Connection Service does not exist, please check!");
        Response response = new EmptyResponse();
        if (query.getQuery().isEmpty() || query.getQuery().isEverything()) {
            return response;
        }
        Optional<String> base64Request = RequestSerializer.requestToBase64(query);
        if (base64Request.isPresent()) {
            try {
                URIBuilder builder = new URIBuilder(this.serverURL);
                StringEntity requestBody = new StringEntity(base64Request.get());
                HttpPost httpPost = new HttpPost(builder.build());
                httpPost.setEntity((HttpEntity)requestBody);
                try (CloseableHttpResponse requestResponse = this.httpClient.execute((HttpUriRequest)httpPost);){
                    int statusCode = requestResponse.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        long hitCount = this.getTotalRecords(requestResponse);
                        String cursorMark = this.getNextPageCursor(requestResponse);
                        List<T> responseItems = this.getResponseItems(requestResponse);
                        response = new JapiResponseImpl<T>(responseItems, query.getResultOffset(), hitCount, cursorMark);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Unexpected error while requesting the service with query: " + query.getQuery();
                throw new ServiceException(msg, e);
            }
        }
        return response;
    }

    private List<T> getResponseItems(CloseableHttpResponse response) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        SpecificDatumReader entryDatumReader = new SpecificDatumReader(this.avroEntityClass);
        DataFileStream dataFileReader = new DataFileStream(response.getEntity().getContent(), (DatumReader)entryDatumReader);
        while (dataFileReader.hasNext()) {
            Object item = dataFileReader.next();
            result.add(item);
        }
        return result;
    }

    private long getTotalRecords(CloseableHttpResponse response) {
        long hitCount = 0L;
        if (response.containsHeader(X_PAGINATION_TOTALRECORDS)) {
            String headerValue = response.getHeaders(X_PAGINATION_TOTALRECORDS)[0].getValue();
            hitCount = Integer.parseInt(headerValue);
        }
        return hitCount;
    }

    private String getNextPageCursor(CloseableHttpResponse response) {
        String cursorMark = null;
        if (response.containsHeader("X-NextPageCursorMark")) {
            cursorMark = response.getHeaders("X-NextPageCursorMark")[0].getValue();
        }
        return cursorMark;
    }

    class ServiceDelegate
    extends AbstractIdleService {
        ServiceDelegate() {
        }

        protected void startUp() throws Exception {
            BasicHeader basicHeader = new BasicHeader("JAPI-VERSION", this.getBuildVersion());
            HttpClientBuilder custom = HttpClients.custom();
            custom.setDefaultHeaders(Collections.singletonList(basicHeader));
            RequestConfig.Builder builder = RequestConfig.custom();
            builder.setSocketTimeout(JapiBasicService.this.httpRequestConfig.getSocketTimeOut());
            builder.setConnectTimeout(JapiBasicService.this.httpRequestConfig.getConnectionTimeOut());
            builder.setRedirectsEnabled(false);
            RequestConfig build = builder.build();
            custom.setDefaultRequestConfig(build);
            custom.setMaxConnTotal(JapiBasicService.this.httpRequestConfig.getMaxTotalConnections());
            JapiBasicService.this.httpClient = custom.useSystemProperties().build();
        }

        protected void shutDown() throws Exception {
            if (JapiBasicService.this.httpClient != null) {
                JapiBasicService.this.httpClient.close();
            }
        }

        private String getBuildVersion() {
            try {
                Class<ServiceDelegate> clazz = ServiceDelegate.class;
                String className = clazz.getSimpleName() + ".class";
                String classPath = clazz.getResource(className).toString();
                if (!classPath.startsWith("jar")) {
                    return "UNKNOWN.Not-built-by-UniProt";
                }
                String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
                Manifest manifest = new Manifest(new URL(manifestPath).openStream());
                Attributes attr = manifest.getMainAttributes();
                String value = attr.getValue("UniProt-JAPI-Version");
                if (!Strings.isNullOrEmpty((String)value)) {
                    return value;
                }
                return "UNKNOWN.Not-set";
            }
            catch (Exception e) {
                return "UNKNOWN.Cannot-get";
            }
        }
    }
}

