/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.main;

import java.time.Duration;
import java.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.xml.common.XmlBuildStats;
import uk.ac.ebi.kraken.xml.exception.UniProtXmlException;
import uk.ac.ebi.kraken.xml.uniprot.main.UniProtXmlBuilder;
import uk.ac.ebi.kraken.xml.uniprot.main.UniProtXmlConfigure;
import uk.ac.ebi.kraken.xml.uniprot.main.UniProtXmlConfigureImpl;

public class UniProtXmlBuilderMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniProtXmlBuilderMain.class);

    public static void main(String[] args) {
        LocalTime start = LocalTime.now();
        UniProtXmlConfigure configure = UniProtXmlConfigureImpl.fromCommandLine(args);
        if (!configure.isValid()) {
            System.out.println(configure.getUsage());
            System.exit(1);
        }
        UniProtXmlBuilder builder = new UniProtXmlBuilder(configure);
        try {
            XmlBuildStats stats = builder.build(configure.getUniProtInputFFilePath(), configure.getUniProtXmlOutputFilePath());
            System.out.println(stats.getReport());
            Duration duration = Duration.between(start, LocalTime.now());
            LOGGER.info("Total time: " + duration.getSeconds() + " seconds");
            if (stats.getNumberOfEntryFailed() > 0L) {
                System.exit(1);
            }
        }
        catch (UniProtXmlException e) {
            LOGGER.error("Executing failure", (Throwable)e);
            System.exit(1);
        }
    }
}

