/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.dbxref;

import uk.ac.ebi.kraken.interfaces.annotations.XMLTagName;
import uk.ac.ebi.kraken.interfaces.factories.XRefFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.Go;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoEvidenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoTerm;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.PropertyType;
import uk.ac.ebi.kraken.xml.xdb.GoEvidenceConverterUtil;

public class GoDbXrefHandler
implements GenericHandler<DatabaseCrossReference, DbReferenceType> {
    private final XRefFactory xRefFactory;
    private final ObjectFactory objectFactory;
    private final GenericHandler<DatabaseCrossReference, DbReferenceType> baseDbXrefHandler;
    private static final String goTermTagXMLTag = GoTerm.class.getAnnotation(XMLTagName.class).tagName();
    private static final String goEvidenceTagXMLTag = GoEvidenceType.class.getAnnotation(XMLTagName.class).tagName();

    public GoDbXrefHandler(XRefFactory xRefFactory, ObjectFactory objectFactory, GenericHandler<DatabaseCrossReference, DbReferenceType> baseDbXrefHandler) {
        this.xRefFactory = xRefFactory;
        this.objectFactory = objectFactory;
        this.baseDbXrefHandler = baseDbXrefHandler;
    }

    @Override
    public DatabaseCrossReference fromXmlBinding(DbReferenceType xmlObject) {
        DatabaseCrossReference dbXref = this.baseDbXrefHandler.fromXmlBinding(xmlObject);
        dbXref.setPrimaryId(this.xRefFactory.buildXDBAttribute(xmlObject.getId()));
        String thirdValue = null;
        for (PropertyType property : xmlObject.getProperty()) {
            PropertyType xmlProperty = property;
            if (xmlProperty.getType().equalsIgnoreCase(goTermTagXMLTag)) {
                this.populateGoTerm(dbXref, xmlProperty);
                continue;
            }
            if (xmlProperty.getType().equalsIgnoreCase(goEvidenceTagXMLTag)) {
                thirdValue = GoEvidenceConverterUtil.INSTANCE.convertFromECOCode(xmlProperty.getValue()).getValue();
                continue;
            }
            if (!xmlProperty.getType().equals("project")) continue;
            dbXref.setThird(this.xRefFactory.buildXDBAttribute(thirdValue + ":" + xmlProperty.getValue()));
        }
        return this.xRefFactory.buildGo(dbXref);
    }

    private void populateGoTerm(DatabaseCrossReference go, PropertyType xmlProperty) {
        String termString = xmlProperty.getValue();
        go.setDescription(this.xRefFactory.buildXDBAttribute(termString));
    }

    @Override
    public DbReferenceType toXmlBinding(DatabaseCrossReference dbXref) {
        Go goXref = this.xRefFactory.buildGo(dbXref);
        DbReferenceType xmlReference = this.baseDbXrefHandler.toXmlBinding(dbXref);
        xmlReference.getProperty().add(this.loadTerm(goXref));
        if (!goXref.getGoEvidenceType().getValue().isEmpty()) {
            xmlReference.getProperty().add(this.loadEvidence(goXref));
        }
        if (!goXref.getGoEvidenceSource().getValue().isEmpty()) {
            xmlReference.getProperty().add(this.loadProject(goXref));
        }
        return xmlReference;
    }

    private PropertyType loadTerm(Go goXref) {
        PropertyType propertyTerm = this.objectFactory.createPropertyType();
        propertyTerm.setType(GoTerm.class.getAnnotation(XMLTagName.class).tagName());
        propertyTerm.setValue(goXref.getOntologyType().getValue() + goXref.getGoTerm().getValue());
        return propertyTerm;
    }

    private PropertyType loadEvidence(Go goXref) {
        PropertyType propertyEvidence = this.objectFactory.createPropertyType();
        propertyEvidence.setType(GoEvidenceType.class.getAnnotation(XMLTagName.class).tagName());
        String evidenceType = goXref.getGoEvidenceType().getValue();
        GoEvidenceType goEvidenceType = GoEvidenceType.valueOf(evidenceType);
        String ecoDbXref = GoEvidenceConverterUtil.INSTANCE.convertToECOCode(goEvidenceType);
        propertyEvidence.setValue(ecoDbXref);
        return propertyEvidence;
    }

    private PropertyType loadProject(Go goXref) {
        PropertyType propertyProject = this.objectFactory.createPropertyType();
        propertyProject.setType("project");
        propertyProject.setValue(goXref.getGoEvidenceSource().getValue());
        return propertyProject;
    }
}

